/*
 * Decompiled with CFR 0.152.
 */
package swim.js;

import java.io.File;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.graalvm.polyglot.Engine;
import swim.api.agent.AgentDef;
import swim.api.agent.AgentFactory;
import swim.api.plane.PlaneDef;
import swim.api.plane.PlaneFactory;
import swim.dynamic.api.SwimApi;
import swim.dynamic.java.JavaBase;
import swim.dynamic.observable.SwimObservable;
import swim.dynamic.structure.SwimStructure;
import swim.js.JsAgentDef;
import swim.js.JsAgentFactory;
import swim.js.JsPlaneDef;
import swim.js.JsPlaneFactory;
import swim.kernel.KernelProxy;
import swim.structure.Item;
import swim.structure.Value;
import swim.uri.Uri;
import swim.uri.UriPath;
import swim.vm.js.JsCachedModuleResolver;
import swim.vm.js.JsHostRuntime;
import swim.vm.js.JsModuleResolver;
import swim.vm.js.JsNodeModuleResolver;
import swim.vm.js.JsRuntime;

public class JsKernel
extends KernelProxy {
    final double kernelPriority;
    volatile Engine jsEngine;
    volatile JsRuntime jsRuntime;
    volatile UriPath rootPath;
    private static final double KERNEL_PRIORITY = 1.75;
    static final AtomicReferenceFieldUpdater<JsKernel, Engine> JS_ENGINE = AtomicReferenceFieldUpdater.newUpdater(JsKernel.class, Engine.class, "jsEngine");
    static final AtomicReferenceFieldUpdater<JsKernel, JsRuntime> JS_RUNTIME = AtomicReferenceFieldUpdater.newUpdater(JsKernel.class, JsRuntime.class, "jsRuntime");
    static final AtomicReferenceFieldUpdater<JsKernel, UriPath> ROOT_PATH = AtomicReferenceFieldUpdater.newUpdater(JsKernel.class, UriPath.class, "rootPath");

    public JsKernel(double kernelPriority) {
        this.kernelPriority = kernelPriority;
    }

    public JsKernel() {
        this(1.75);
    }

    public final double kernelPriority() {
        return this.kernelPriority;
    }

    protected Engine createJsEngine() {
        return Engine.newBuilder().build();
    }

    protected JsModuleResolver createJsModuleResolver() {
        JsNodeModuleResolver moduleResolver = new JsNodeModuleResolver(this.rootPath());
        moduleResolver = new JsCachedModuleResolver((JsModuleResolver)moduleResolver);
        return moduleResolver;
    }

    protected JsRuntime createJsRuntime() {
        JsModuleResolver moduleResolver = this.createJsModuleResolver();
        JsHostRuntime runtime = new JsHostRuntime(moduleResolver);
        runtime.addHostLibrary(JavaBase.LIBRARY);
        runtime.addHostLibrary(SwimStructure.LIBRARY);
        runtime.addHostModule("@swim/structure", SwimStructure.LIBRARY);
        runtime.addHostLibrary(SwimObservable.LIBRARY);
        runtime.addHostModule("@swim/observable", SwimObservable.LIBRARY);
        runtime.addHostLibrary(SwimApi.LIBRARY);
        runtime.addHostModule("@swim/api", SwimApi.LIBRARY);
        return runtime;
    }

    protected UriPath createRootPath() {
        return UriPath.parse((String)new File("").getAbsolutePath().replace('\\', '/'));
    }

    public final Engine jsEngine() {
        Engine jsEngine;
        block2: {
            Engine oldJsEngine;
            Engine newJsEngine = null;
            do {
                if ((oldJsEngine = this.jsEngine) != null) {
                    jsEngine = oldJsEngine;
                    if (newJsEngine == null) break block2;
                    newJsEngine.close();
                    newJsEngine = null;
                    break block2;
                }
                if (newJsEngine != null) continue;
                newJsEngine = this.createJsEngine();
            } while (!JS_ENGINE.compareAndSet(this, oldJsEngine, newJsEngine));
            jsEngine = newJsEngine;
        }
        return jsEngine;
    }

    public final JsRuntime jsRuntime() {
        JsRuntime jsRuntime;
        block2: {
            JsRuntime oldJsRuntime;
            JsRuntime newJsRuntime = null;
            do {
                if ((oldJsRuntime = this.jsRuntime) != null) {
                    jsRuntime = oldJsRuntime;
                    if (newJsRuntime == null) break block2;
                    newJsRuntime = null;
                    break block2;
                }
                if (newJsRuntime != null) continue;
                newJsRuntime = this.createJsRuntime();
            } while (!JS_RUNTIME.compareAndSet(this, oldJsRuntime, newJsRuntime));
            jsRuntime = newJsRuntime;
        }
        return jsRuntime;
    }

    public final UriPath rootPath() {
        UriPath rootPath;
        block2: {
            UriPath oldRootPath;
            UriPath newRootPath = null;
            do {
                if ((oldRootPath = this.rootPath) != null) {
                    rootPath = oldRootPath;
                    if (newRootPath == null) break block2;
                    newRootPath = null;
                    break block2;
                }
                if (newRootPath != null) continue;
                newRootPath = this.createRootPath();
            } while (!ROOT_PATH.compareAndSet(this, oldRootPath, newRootPath));
            rootPath = newRootPath;
        }
        return rootPath;
    }

    public void setRootPath(UriPath rootPath) {
        ROOT_PATH.set(this, rootPath);
    }

    public PlaneDef definePlane(Item planeConfig) {
        JsPlaneDef planeDef = this.defineJsPlane(planeConfig);
        return planeDef != null ? planeDef : super.definePlane(planeConfig);
    }

    public JsPlaneDef defineJsPlane(Item planeConfig) {
        UriPath planeModulePath;
        Value value = planeConfig.toValue();
        Value header = value.getAttr("plane");
        if (header.isDefined() && (planeModulePath = (UriPath)header.get("js").cast(UriPath.pathForm())) != null) {
            String planeName = planeConfig.key().stringValue(planeModulePath.toString());
            return new JsPlaneDef(planeName, planeModulePath);
        }
        return null;
    }

    public PlaneFactory<?> createPlaneFactory(PlaneDef planeDef, ClassLoader classLoader) {
        if (planeDef instanceof JsPlaneDef) {
            return this.createJsPlaneFactory((JsPlaneDef)planeDef);
        }
        return super.createPlaneFactory(planeDef, classLoader);
    }

    public JsPlaneFactory createJsPlaneFactory(JsPlaneDef planeDef) {
        return new JsPlaneFactory(this, this.rootPath(), planeDef);
    }

    public AgentDef defineAgent(Item agentConfig) {
        JsAgentDef agentDef = this.defineJsAgent(agentConfig);
        return agentDef != null ? agentDef : super.defineAgent(agentConfig);
    }

    public JsAgentDef defineJsAgent(Item agentConfig) {
        UriPath agentModulePath;
        Value value = agentConfig.toValue();
        Value header = value.getAttr("agent");
        if (header.isDefined() && (agentModulePath = (UriPath)header.get("js").cast(UriPath.pathForm())) != null) {
            String agentName = agentConfig.key().stringValue(agentModulePath.toString());
            Value props = value.get("props");
            return new JsAgentDef(agentName, agentModulePath, props);
        }
        return null;
    }

    public AgentFactory<?> createAgentFactory(AgentDef agentDef, ClassLoader classLoader) {
        if (agentDef instanceof JsAgentDef) {
            return this.createJsAgentFactory((JsAgentDef)agentDef);
        }
        return super.createAgentFactory(agentDef, classLoader);
    }

    public AgentFactory<?> createAgentFactory(String edgeName, Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, AgentDef agentDef) {
        if (agentDef instanceof JsAgentDef) {
            return this.createJsAgentFactory((JsAgentDef)agentDef);
        }
        return super.createAgentFactory(edgeName, meshUri, partKey, hostUri, nodeUri, agentDef);
    }

    public JsAgentFactory createJsAgentFactory(JsAgentDef agentDef) {
        return new JsAgentFactory(this, this.rootPath(), agentDef);
    }

    public static JsKernel fromValue(Value moduleConfig) {
        Value header = moduleConfig.getAttr("kernel");
        String kernelClassName = header.get("class").stringValue(null);
        if (kernelClassName == null || JsKernel.class.getName().equals(kernelClassName)) {
            double kernelPriority = header.get("priority").doubleValue(1.75);
            return new JsKernel(kernelPriority);
        }
        return null;
    }
}

