/*
 * Decompiled with CFR 0.152.
 */
package swim.js;

import swim.api.plane.Plane;
import swim.api.plane.PlaneContext;
import swim.dynamic.GuestWrapper;
import swim.vm.js.JsBridge;
import swim.vm.js.JsModule;

public class JsPlane
implements Plane,
GuestWrapper {
    protected final PlaneContext planeContext;
    protected final JsBridge bridge;
    protected final JsModule module;
    protected final Object guest;

    public JsPlane(PlaneContext planeContext, JsBridge bridge, JsModule module, Object guest) {
        this.planeContext = planeContext;
        this.bridge = bridge;
        this.module = module;
        this.guest = guest;
    }

    public final PlaneContext planeContext() {
        return this.planeContext;
    }

    public final JsBridge bridge() {
        return this.bridge;
    }

    public final JsModule module() {
        return this.module;
    }

    public final Object unwrap() {
        return this.guest;
    }

    public void willStart() {
        if (this.bridge.guestCanInvokeMember(this.guest, "willStart")) {
            this.bridge.guestInvokeMember(this.guest, "willStart", new Object[0]);
        }
    }

    public void didStart() {
        if (this.bridge.guestCanInvokeMember(this.guest, "didStart")) {
            this.bridge.guestInvokeMember(this.guest, "didStart", new Object[0]);
        }
    }

    public void willStop() {
        if (this.bridge.guestCanInvokeMember(this.guest, "willStop")) {
            this.bridge.guestInvokeMember(this.guest, "willStop", new Object[0]);
        }
    }

    public void didStop() {
        if (this.bridge.guestCanInvokeMember(this.guest, "didStop")) {
            this.bridge.guestInvokeMember(this.guest, "didStop", new Object[0]);
        }
    }

    public void willClose() {
        if (this.bridge.guestCanInvokeMember(this.guest, "willClose")) {
            this.bridge.guestInvokeMember(this.guest, "willClose", new Object[0]);
        }
    }

    public void didClose() {
        if (this.bridge.guestCanInvokeMember(this.guest, "didClose")) {
            this.bridge.guestInvokeMember(this.guest, "didClose", new Object[0]);
        }
    }

    public void didFail(Throwable error) {
        if (this.bridge.guestCanInvokeMember(this.guest, "didFail")) {
            this.bridge.guestInvokeMember(this.guest, "didFail", new Object[]{error});
        } else {
            error.printStackTrace();
        }
    }
}

