/*
 * Decompiled with CFR 0.152.
 */
package swim.js;

import swim.api.plane.PlaneDef;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.uri.UriPath;
import swim.util.Murmur3;

public class JsPlaneDef
implements PlaneDef,
Debug {
    final String planeName;
    final UriPath modulePath;
    private static int hashSeed;

    public JsPlaneDef(String planeName, UriPath modulePath) {
        this.planeName = planeName;
        this.modulePath = modulePath;
    }

    public final String planeName() {
        return this.planeName;
    }

    public JsPlaneDef planeName(String planeName) {
        return this.copy(planeName, this.modulePath);
    }

    public final UriPath modulePath() {
        return this.modulePath;
    }

    public JsPlaneDef modulePath(UriPath modulePath) {
        return this.copy(this.planeName, modulePath);
    }

    protected JsPlaneDef copy(String planeName, UriPath modulePath) {
        return new JsPlaneDef(planeName, modulePath);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof JsPlaneDef) {
            JsPlaneDef that = (JsPlaneDef)other;
            return (this.planeName == null ? that.planeName == null : this.planeName.equals(that.planeName)) && (this.modulePath == null ? that.modulePath == null : this.modulePath.equals((Object)that.modulePath));
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(JsPlaneDef.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((Object)this.planeName)), (int)Murmur3.hash((Object)this.modulePath)));
    }

    public void debug(Output<?> output) {
        output = output.write("JsPlaneDef").write(46).write("from").write(40).debug((Object)this.planeName).write(", ").debug((Object)this.modulePath).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static JsPlaneDef from(String planeName, UriPath modulePath) {
        return new JsPlaneDef(planeName, modulePath);
    }

    public static JsPlaneDef from(String planeName, String modulePath) {
        return new JsPlaneDef(planeName, UriPath.parse((String)modulePath));
    }

    public static JsPlaneDef fromModulePath(UriPath modulePath) {
        return new JsPlaneDef(modulePath.toString(), modulePath);
    }

    public static JsPlaneDef fromModulePath(String modulePath) {
        return new JsPlaneDef(modulePath, UriPath.parse((String)modulePath));
    }
}

