/*
 * Decompiled with CFR 0.152.
 */
package swim.js;

import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;
import swim.api.plane.PlaneContext;
import swim.api.plane.PlaneFactory;
import swim.js.JsKernel;
import swim.js.JsPlane;
import swim.js.JsPlaneDef;
import swim.uri.UriPath;
import swim.vm.js.JsBridge;
import swim.vm.js.JsModule;
import swim.vm.js.JsModuleLoader;
import swim.vm.js.JsModuleSystem;

public class JsPlaneFactory
implements PlaneFactory<JsPlane> {
    protected final JsKernel jsKernel;
    protected final UriPath basePath;
    protected final JsPlaneDef planeDef;

    public JsPlaneFactory(JsKernel jsKernel, UriPath basePath, JsPlaneDef planeDef) {
        this.jsKernel = jsKernel;
        this.basePath = basePath;
        this.planeDef = planeDef;
    }

    public final JsKernel jsKernel() {
        return this.jsKernel;
    }

    public final UriPath basePath() {
        return this.basePath;
    }

    public final JsPlaneDef planeDef() {
        return this.planeDef;
    }

    protected Context createPlaneJsContext(PlaneContext planeContext) {
        return Context.newBuilder((String[])new String[]{"js"}).engine(this.jsKernel.jsEngine()).build();
    }

    protected JsBridge createPlaneJsBridge(PlaneContext planeContext, Context jsContext) {
        return new JsBridge(this.jsKernel.jsRuntime(), jsContext);
    }

    protected JsModuleSystem createPlaneModuleSystem(PlaneContext planeContext, Context jsContext, JsBridge jsBridge) {
        return new JsModuleSystem(jsContext, (JsModuleLoader)jsBridge);
    }

    protected JsModule requirePlaneModule(PlaneContext planeContext, JsModuleSystem moduleSystem) {
        return moduleSystem.requireModule(this.basePath(), this.planeDef.modulePath());
    }

    protected Value createGuestPlane(PlaneContext planeContext, JsBridge jsBridge, JsModule planeModule) {
        Value guestPlane;
        Object guestPlaneContext = jsBridge.hostToGuest((Object)planeContext);
        Value planeExports = planeModule.moduleExports();
        if (planeExports.canInstantiate()) {
            guestPlane = planeExports.newInstance(new Object[]{guestPlaneContext});
        } else {
            guestPlane = planeExports;
            if (guestPlane.hasMembers()) {
                guestPlane.putMember("context", guestPlaneContext);
            }
        }
        return guestPlane;
    }

    public JsPlane createPlane(PlaneContext planeContext) {
        Context jsContext = this.createPlaneJsContext(planeContext);
        JsBridge jsBridge = this.createPlaneJsBridge(planeContext, jsContext);
        JsModuleSystem moduleSystem = this.createPlaneModuleSystem(planeContext, jsContext, jsBridge);
        JsModule module = this.requirePlaneModule(planeContext, moduleSystem);
        Value guest = this.createGuestPlane(planeContext, jsBridge, module);
        return new JsPlane(planeContext, jsBridge, module, guest);
    }
}

