/*
 * Decompiled with CFR 0.152.
 */
package swim.kernel;

import swim.api.agent.Agent;
import swim.api.agent.AgentDef;
import swim.api.agent.AgentFactory;
import swim.api.plane.Plane;
import swim.api.plane.PlaneDef;
import swim.api.plane.PlaneFactory;
import swim.api.service.Service;
import swim.api.service.ServiceDef;
import swim.api.service.ServiceFactory;
import swim.api.space.Space;
import swim.api.space.SpaceDef;
import swim.structure.Item;

public interface Kernel {
    public double kernelPriority();

    public Kernel injectKernel(Kernel var1);

    public <T> T unwrapKernel(Class<T> var1);

    public ServiceDef defineService(Item var1);

    public ServiceFactory<?> createServiceFactory(ServiceDef var1, ClassLoader var2);

    public <S extends Service> S openService(String var1, ServiceFactory<S> var2);

    default public Service openService(ServiceDef serviceDef, ClassLoader classLoader) {
        ServiceFactory<?> serviceFactory;
        String serviceName = serviceDef.serviceName();
        Object service = this.getService(serviceName);
        if (service == null && (serviceFactory = this.createServiceFactory(serviceDef, classLoader)) != null) {
            service = this.openService(serviceName, serviceFactory);
        }
        return service;
    }

    default public Service openService(ServiceDef serviceDef) {
        return this.openService(serviceDef, null);
    }

    public Service getService(String var1);

    public SpaceDef defineSpace(Item var1);

    public Space openSpace(SpaceDef var1);

    public Space getSpace(String var1);

    public PlaneDef definePlane(Item var1);

    public PlaneFactory<?> createPlaneFactory(PlaneDef var1, ClassLoader var2);

    public <P extends Plane> PlaneFactory<P> createPlaneFactory(Class<? extends P> var1);

    public AgentDef defineAgent(Item var1);

    public AgentFactory<?> createAgentFactory(AgentDef var1, ClassLoader var2);

    public <A extends Agent> AgentFactory<A> createAgentFactory(Class<? extends A> var1);

    public boolean isStarted();

    public void start();

    public void stop();

    public void run();
}

