/*
 * Decompiled with CFR 0.152.
 */
package swim.loader;

import java.util.Iterator;
import java.util.ServiceLoader;
import swim.api.SwimContext;
import swim.api.client.Client;
import swim.api.client.ClientContext;
import swim.api.router.Router;
import swim.linker.ClientLinker;
import swim.loader.GenericClient;
import swim.loader.RouterLoader;

public final class ClientLoader {
    private ClientLoader() {
    }

    public static Client load() {
        ClientContext context = ClientLoader.loadClientContext();
        Router router = RouterLoader.loadRouter();
        context.setRouter(router);
        Client client = ClientLoader.loadClient(context);
        if (context instanceof ClientLinker) {
            // empty if block
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Client loadClient(ClientContext context) {
        try {
            SwimContext.setClientContext((ClientContext)context);
            ServiceLoader<Client> clientLoader = ServiceLoader.load(Client.class);
            Iterator<Client> clients = clientLoader.iterator();
            if (clients.hasNext()) {
                Client client = clients.next();
                return client;
            }
            GenericClient genericClient = new GenericClient();
            return genericClient;
        }
        finally {
            SwimContext.setClientContext(null);
        }
    }

    public static ClientContext loadClientContext() {
        ServiceLoader<ClientContext> clientContextLoader = ServiceLoader.load(ClientContext.class);
        Iterator<ClientContext> clientContexts = clientContextLoader.iterator();
        if (clientContexts.hasNext()) {
            return clientContexts.next();
        }
        return null;
    }
}

