/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.mqtt.MqttDecoder;
import swim.mqtt.MqttException;
import swim.mqtt.MqttPublish;
import swim.mqtt.MqttValue;

final class MqttPublishDecoder<T>
extends Decoder<MqttPublish<T>> {
    final MqttDecoder mqtt;
    final Decoder<T> payload;
    final int packetFlags;
    final Decoder<String> topicName;
    final int packetId;
    final int remaining;
    final int step;

    MqttPublishDecoder(MqttDecoder mqtt, Decoder<T> payload, int packetFlags, Decoder<String> topicName, int packetId, int remaining, int step) {
        this.mqtt = mqtt;
        this.payload = payload;
        this.packetFlags = packetFlags;
        this.topicName = topicName;
        this.packetId = packetId;
        this.remaining = remaining;
        this.step = step;
    }

    MqttPublishDecoder(MqttDecoder mqtt, Decoder<T> payload) {
        this(mqtt, payload, 0, null, 0, 0, 1);
    }

    public Decoder<MqttPublish<T>> feed(InputBuffer input) {
        return MqttPublishDecoder.decode(input, this.mqtt, this.payload, this.packetFlags, this.topicName, this.packetId, this.remaining, this.step);
    }

    static <T> Decoder<MqttPublish<T>> decode(InputBuffer input, MqttDecoder mqtt, Decoder<T> payload, int packetFlags, Decoder<String> topicName, int packetId, int remaining, int step) {
        boolean inputPart;
        int inputRemaining;
        int inputLimit;
        int inputStart;
        if (step == 1 && input.isCont()) {
            packetFlags = input.head() & 0xF;
            input = input.step();
            step = 2;
        }
        while (step >= 2 && step <= 5 && input.isCont()) {
            int b = input.head();
            input = input.step();
            remaining |= (b & 0x7F) << 7 * (step - 2);
            if ((b & 0x80) == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return MqttPublishDecoder.error((Throwable)new MqttException("packet length too long"));
        }
        if (step == 6) {
            inputStart = input.index();
            inputLimit = input.limit();
            inputRemaining = inputLimit - inputStart;
            if (remaining < inputRemaining) {
                input = input.limit(inputStart + remaining);
            }
            inputPart = input.isPart();
            input = input.isPart(remaining > inputRemaining);
            topicName = topicName == null ? mqtt.decodeString(input) : topicName.feed(input);
            input = input.limit(inputLimit).isPart(inputPart);
            remaining -= input.index() - inputStart;
            if (topicName.isDone()) {
                step = (packetFlags & 6) >>> 1 != 0 ? 7 : 9;
            } else if (topicName.isError()) {
                return topicName.asError();
            }
        }
        if (step == 7 && remaining > 0 && input.isCont()) {
            packetId = input.head() << 8;
            input = input.step();
            --remaining;
            step = 8;
        }
        if (step == 8 && remaining > 0 && input.isCont()) {
            packetId |= input.head();
            input = input.step();
            --remaining;
            step = 9;
        }
        if (step == 9) {
            inputStart = input.index();
            inputLimit = input.limit();
            inputRemaining = inputLimit - inputStart;
            if (remaining < inputRemaining) {
                input = input.limit(inputStart + remaining);
            }
            inputPart = input.isPart();
            input = input.isPart(remaining > inputRemaining);
            payload = payload.feed(input);
            input = input.limit(inputLimit).isPart(inputPart);
            remaining -= input.index() - inputStart;
            if (payload.isDone()) {
                step = 10;
            } else if (payload.isError()) {
                return payload.asError();
            }
        }
        if (step == 10 && remaining == 0) {
            return MqttPublishDecoder.done(mqtt.publish(packetFlags, (String)topicName.bind(), packetId, MqttValue.from(payload.bind())));
        }
        if (remaining < 0) {
            return MqttPublishDecoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (input.isDone()) {
            return MqttPublishDecoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return MqttPublishDecoder.error((Throwable)input.trap());
        }
        return new MqttPublishDecoder<T>(mqtt, payload, packetFlags, (Decoder<String>)topicName, packetId, remaining, step);
    }

    static <T> Decoder<MqttPublish<T>> decode(InputBuffer input, MqttDecoder mqtt, Decoder<T> payload) {
        return MqttPublishDecoder.decode(input, mqtt, payload, 0, null, 0, 0, 1);
    }
}

