/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.collections.FingerTrieSeq;
import swim.mqtt.MqttDecoder;
import swim.mqtt.MqttException;
import swim.mqtt.MqttUnsubscribe;

final class MqttUnsubscribeDecoder
extends Decoder<MqttUnsubscribe> {
    final MqttDecoder mqtt;
    final int packetFlags;
    final int packetId;
    final FingerTrieSeq<String> topicNames;
    final Decoder<String> topicName;
    final int remaining;
    final int step;

    MqttUnsubscribeDecoder(MqttDecoder mqtt, int packetFlags, int packetId, FingerTrieSeq<String> topicNames, Decoder<String> topicName, int remaining, int step) {
        this.mqtt = mqtt;
        this.packetFlags = packetFlags;
        this.packetId = packetId;
        this.topicNames = topicNames;
        this.topicName = topicName;
        this.remaining = remaining;
        this.step = step;
    }

    MqttUnsubscribeDecoder(MqttDecoder mqtt) {
        this(mqtt, 0, 0, (FingerTrieSeq<String>)FingerTrieSeq.empty(), null, 0, 1);
    }

    public Decoder<MqttUnsubscribe> feed(InputBuffer input) {
        return MqttUnsubscribeDecoder.decode(input, this.mqtt, this.packetFlags, this.packetId, this.topicNames, this.topicName, this.remaining, this.step);
    }

    static Decoder<MqttUnsubscribe> decode(InputBuffer input, MqttDecoder mqtt, int packetFlags, int packetId, FingerTrieSeq<String> topicNames, Decoder<String> topicName, int remaining, int step) {
        if (step == 1 && input.isCont()) {
            packetFlags = input.head() & 0xF;
            input = input.step();
            step = 2;
        }
        while (step >= 2 && step <= 5 && input.isCont()) {
            int b = input.head();
            input = input.step();
            remaining |= (b & 0x7F) << 7 * (step - 2);
            if ((b & 0x80) == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return MqttUnsubscribeDecoder.error((Throwable)new MqttException("packet length too long"));
        }
        if (step == 6 && remaining > 0 && input.isCont()) {
            packetId = input.head() << 8;
            input = input.step();
            --remaining;
            step = 7;
        }
        if (step == 7 && remaining > 0 && input.isCont()) {
            packetId |= input.head();
            input = input.step();
            step = --remaining > 0 ? 8 : 9;
        }
        while (step == 8 && remaining > 0 && input.isCont()) {
            int inputStart = input.index();
            int inputLimit = input.limit();
            int inputRemaining = inputLimit - inputStart;
            if (remaining < inputRemaining) {
                input = input.limit(inputStart + remaining);
            }
            boolean inputPart = input.isPart();
            input = input.isPart(remaining > inputRemaining);
            topicName = topicName == null ? mqtt.decodeString(input) : topicName.feed(input);
            input = input.limit(inputLimit);
            remaining -= input.index() - inputStart;
            if (topicName.isDone()) {
                topicNames = topicNames.appended((Object)((String)topicName.bind()));
                topicName = null;
                if (remaining != 0) continue;
                step = 9;
                break;
            }
            if (!topicName.isError()) continue;
            return topicName.asError();
        }
        if (step == 9 && remaining == 0) {
            return MqttUnsubscribeDecoder.done((Object)mqtt.unsubscribe(packetFlags, packetId, topicNames));
        }
        if (remaining < 0) {
            return MqttUnsubscribeDecoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (input.isDone()) {
            return MqttUnsubscribeDecoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return MqttUnsubscribeDecoder.error((Throwable)input.trap());
        }
        return new MqttUnsubscribeDecoder(mqtt, packetFlags, packetId, (FingerTrieSeq<String>)topicNames, (Decoder<String>)topicName, remaining, step);
    }

    static Decoder<MqttUnsubscribe> decode(InputBuffer input, MqttDecoder mqtt) {
        return MqttUnsubscribeDecoder.decode(input, mqtt, 0, 0, (FingerTrieSeq<String>)FingerTrieSeq.empty(), null, 0, 1);
    }
}

