/*
 * Decompiled with CFR 0.152.
 */
package swim.protobuf;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.protobuf.ProtobufDecoder;
import swim.protobuf.WireType;

final class FieldDecoder<I, V>
extends Decoder<I> {
    final ProtobufDecoder<I, V> protobuf;
    final Decoder<V> payloadDecoder;
    final Decoder<V> valueDecoder;
    final long tag;
    final int tagShift;
    final int step;

    FieldDecoder(ProtobufDecoder<I, V> protobuf, Decoder<V> payloadDecoder, Decoder<V> valueDecoder, long tag, int tagShift, int step) {
        this.protobuf = protobuf;
        this.payloadDecoder = payloadDecoder;
        this.tag = tag;
        this.tagShift = tagShift;
        this.valueDecoder = valueDecoder;
        this.step = step;
    }

    public Decoder<I> feed(InputBuffer input) {
        return FieldDecoder.decode(input, this.protobuf, this.payloadDecoder, this.valueDecoder, this.tag, this.tagShift, this.step);
    }

    static <I, V> Decoder<I> decode(InputBuffer input, ProtobufDecoder<I, V> protobuf, Decoder<V> payloadDecoder, Decoder<V> valueDecoder, long tag, int tagShift, int step) {
        if (step == 1) {
            while (input.isCont()) {
                int b = input.head();
                if (tagShift < 64) {
                    input = input.step();
                    tag |= (long)(b & 0x7F) << tagShift;
                } else {
                    return FieldDecoder.error((Throwable)new DecoderException("varint overflow"));
                }
                if ((b & 0x80) == 0) {
                    step = 2;
                    break;
                }
                tagShift += 7;
            }
        }
        if (step == 2) {
            if (valueDecoder == null) {
                WireType wireType = WireType.apply((int)tag & 7);
                valueDecoder = protobuf.decodeValue(wireType, payloadDecoder, input);
            } else {
                valueDecoder = valueDecoder.feed(input);
            }
            if (valueDecoder.isDone()) {
                return FieldDecoder.done(protobuf.field(tag >>> 3, valueDecoder.bind()));
            }
            if (valueDecoder.isError()) {
                return valueDecoder.asError();
            }
        }
        if (input.isDone()) {
            return FieldDecoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return FieldDecoder.error((Throwable)input.trap());
        }
        return new FieldDecoder<I, V>(protobuf, payloadDecoder, valueDecoder, tag, tagShift, step);
    }

    static <I, V> Decoder<I> decode(InputBuffer input, ProtobufDecoder<I, V> protobuf, Decoder<V> payloadDecoder) {
        return FieldDecoder.decode(input, protobuf, payloadDecoder, null, 0L, 0, 1);
    }
}

