/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import swim.api.Link;
import swim.api.SwimContext;
import swim.api.agent.AgentContext;
import swim.api.http.function.DecodeRequestHttp;
import swim.api.http.function.DidRequestHttp;
import swim.api.http.function.DidRespondHttp;
import swim.api.http.function.DoRespondHttp;
import swim.api.http.function.WillRequestHttp;
import swim.api.http.function.WillRespondHttp;
import swim.api.lane.CommandLane;
import swim.api.lane.Lane;
import swim.api.lane.function.DidCommand;
import swim.api.lane.function.DidEnter;
import swim.api.lane.function.DidLeave;
import swim.api.lane.function.DidUplink;
import swim.api.lane.function.OnCommand;
import swim.api.lane.function.WillCommand;
import swim.api.lane.function.WillEnter;
import swim.api.lane.function.WillLeave;
import swim.api.lane.function.WillUplink;
import swim.concurrent.Conts;
import swim.runtime.lane.CommandLaneModel;
import swim.runtime.lane.LaneView;
import swim.structure.Form;

public class CommandLaneView<V>
extends LaneView
implements CommandLane<V> {
    protected final AgentContext agentContext;
    protected Form<V> valueForm;
    protected CommandLaneModel laneBinding;

    public CommandLaneView(AgentContext agentContext, Form<V> valueForm, Object observers) {
        super(observers);
        this.agentContext = agentContext;
        this.valueForm = valueForm;
    }

    public CommandLaneView(AgentContext agentContext, Form<V> valueForm) {
        this(agentContext, valueForm, null);
    }

    @Override
    public AgentContext agentContext() {
        return this.agentContext;
    }

    @Override
    public CommandLaneModel getLaneBinding() {
        return this.laneBinding;
    }

    void setLaneBinding(CommandLaneModel laneBinding) {
        this.laneBinding = laneBinding;
    }

    @Override
    public CommandLaneModel createLaneBinding() {
        return new CommandLaneModel();
    }

    public final Form<V> valueForm() {
        return this.valueForm;
    }

    public <V2> CommandLaneView<V2> valueForm(Form<V2> valueForm) {
        return new CommandLaneView<V2>(this.agentContext, valueForm, this.typesafeObservers(this.observers));
    }

    public <V2> CommandLaneView<V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public void setValueForm(Form<V> valueForm) {
        this.valueForm = valueForm;
    }

    protected Object typesafeObservers(Object observers) {
        return observers;
    }

    public final boolean isSigned() {
        return false;
    }

    public CommandLaneView<V> isSigned(boolean isSigned) {
        return this;
    }

    @Override
    public void close() {
        this.laneBinding.closeLaneView(this);
    }

    @Override
    public CommandLaneView<V> observe(Object observer) {
        return (CommandLaneView)super.observe(observer);
    }

    @Override
    public CommandLaneView<V> unobserve(Object observer) {
        return (CommandLaneView)super.unobserve(observer);
    }

    public CommandLaneView<V> onCommand(OnCommand<V> onCommand) {
        return this.observe(onCommand);
    }

    @Override
    public CommandLaneView<V> willCommand(WillCommand willCommand) {
        return this.observe(willCommand);
    }

    @Override
    public CommandLaneView<V> didCommand(DidCommand didCommand) {
        return this.observe(didCommand);
    }

    @Override
    public CommandLaneView<V> willUplink(WillUplink willUplink) {
        return this.observe(willUplink);
    }

    @Override
    public CommandLaneView<V> didUplink(DidUplink didUplink) {
        return this.observe(didUplink);
    }

    @Override
    public CommandLaneView<V> willEnter(WillEnter willEnter) {
        return this.observe(willEnter);
    }

    @Override
    public CommandLaneView<V> didEnter(DidEnter didEnter) {
        return this.observe(didEnter);
    }

    @Override
    public CommandLaneView<V> willLeave(WillLeave willLeave) {
        return this.observe(willLeave);
    }

    @Override
    public CommandLaneView<V> didLeave(DidLeave didLeave) {
        return this.observe(didLeave);
    }

    @Override
    public CommandLaneView<V> decodeRequest(DecodeRequestHttp<Object> decodeRequest) {
        return this.observe(decodeRequest);
    }

    @Override
    public CommandLaneView<V> willRequest(WillRequestHttp<?> willRequest) {
        return this.observe(willRequest);
    }

    @Override
    public CommandLaneView<V> didRequest(DidRequestHttp<Object> didRequest) {
        return this.observe(didRequest);
    }

    @Override
    public CommandLaneView<V> doRespond(DoRespondHttp<Object> doRespond) {
        return this.observe(doRespond);
    }

    @Override
    public CommandLaneView<V> willRespond(WillRespondHttp<?> willRespond) {
        return this.observe(willRespond);
    }

    @Override
    public CommandLaneView<V> didRespond(DidRespondHttp<?> didRespond) {
        return this.observe(didRespond);
    }

    public void laneOnCommand(V value) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dispatchOnCommand(Link link, V value, boolean preemptive) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        try {
            boolean complete;
            block14: {
                Object observers;
                block12: {
                    block13: {
                        SwimContext.setLane((Lane)this);
                        SwimContext.setLink((Link)link);
                        observers = this.observers;
                        complete = true;
                        if (!(observers instanceof OnCommand)) break block12;
                        if (((OnCommand)observers).isPreemptive() != preemptive) break block13;
                        try {
                            ((OnCommand)observers).onCommand(value);
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                            }
                            throw error;
                        }
                    }
                    if (!preemptive) break block14;
                    complete = false;
                    break block14;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof OnCommand)) continue;
                        if (((OnCommand)observer).isPreemptive() == preemptive) {
                            try {
                                ((OnCommand)observer).onCommand(value);
                                continue;
                            }
                            catch (Throwable error) {
                                if (Conts.isNonFatal((Throwable)error)) {
                                    this.laneDidFail(error);
                                    continue;
                                }
                                throw error;
                            }
                        }
                        if (!preemptive) continue;
                        complete = false;
                    }
                }
            }
            boolean bl = complete;
            return bl;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }
}

