/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import java.util.Iterator;
import java.util.Map;
import swim.structure.Form;
import swim.structure.Slot;
import swim.structure.Value;

final class DemandMapLaneIterator<K, V>
implements Iterator<Map.Entry<Value, Value>> {
    final Iterator<Map.Entry<K, V>> inner;
    final Form<K> keyForm;
    final Form<V> valueForm;

    DemandMapLaneIterator(Iterator<Map.Entry<K, V>> inner, Form<K> keyForm, Form<V> valueForm) {
        this.inner = inner;
        this.keyForm = keyForm;
        this.valueForm = valueForm;
    }

    @Override
    public boolean hasNext() {
        return this.inner.hasNext();
    }

    @Override
    public Map.Entry<Value, Value> next() {
        Map.Entry<K, V> entry = this.inner.next();
        Value key = this.keyForm.mold(entry.getKey()).toValue();
        Value value = this.valueForm.mold(entry.getValue()).toValue();
        return Slot.of((Value)key, (Value)value);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

