/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import java.util.Iterator;
import java.util.Map;
import swim.api.Link;
import swim.api.SwimContext;
import swim.api.agent.AgentContext;
import swim.api.http.function.DecodeRequestHttp;
import swim.api.http.function.DidRequestHttp;
import swim.api.http.function.DidRespondHttp;
import swim.api.http.function.DoRespondHttp;
import swim.api.http.function.WillRequestHttp;
import swim.api.http.function.WillRespondHttp;
import swim.api.lane.DemandMapLane;
import swim.api.lane.Lane;
import swim.api.lane.function.DidCommand;
import swim.api.lane.function.DidEnter;
import swim.api.lane.function.DidLeave;
import swim.api.lane.function.DidUplink;
import swim.api.lane.function.OnCueKey;
import swim.api.lane.function.OnSyncMap;
import swim.api.lane.function.WillCommand;
import swim.api.lane.function.WillEnter;
import swim.api.lane.function.WillLeave;
import swim.api.lane.function.WillUplink;
import swim.api.uplink.Uplink;
import swim.concurrent.Conts;
import swim.runtime.lane.DemandMapLaneIterator;
import swim.runtime.lane.DemandMapLaneModel;
import swim.runtime.lane.LaneView;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;

public class DemandMapLaneView<K, V>
extends LaneView
implements DemandMapLane<K, V> {
    protected final AgentContext agentContext;
    protected Form<K> keyForm;
    protected Form<V> valueForm;
    protected DemandMapLaneModel laneBinding;

    public DemandMapLaneView(AgentContext agentContext, Form<K> keyForm, Form<V> valueForm, Object observers) {
        super(observers);
        this.agentContext = agentContext;
        this.keyForm = keyForm;
        this.valueForm = valueForm;
    }

    public DemandMapLaneView(AgentContext agentContext, Form<K> keyForm, Form<V> valueForm) {
        this(agentContext, keyForm, valueForm, null);
    }

    @Override
    public AgentContext agentContext() {
        return this.agentContext;
    }

    @Override
    public DemandMapLaneModel getLaneBinding() {
        return this.laneBinding;
    }

    void setLaneBinding(DemandMapLaneModel laneBinding) {
        this.laneBinding = laneBinding;
    }

    @Override
    public DemandMapLaneModel createLaneBinding() {
        return new DemandMapLaneModel();
    }

    public final Form<K> keyForm() {
        return this.keyForm;
    }

    public <K2> DemandMapLaneView<K2, V> keyForm(Form<K2> keyForm) {
        return new DemandMapLaneView<K2, V>(this.agentContext, keyForm, this.valueForm, this.typesafeObservers(this.observers));
    }

    public <K2> DemandMapLaneView<K2, V> keyClass(Class<K2> keyClass) {
        return this.keyForm(Form.forClass(keyClass));
    }

    public void setKeyForm(Form<K> keyForm) {
        this.keyForm = keyForm;
    }

    public final Form<V> valueForm() {
        return this.valueForm;
    }

    public <V2> DemandMapLaneView<K, V2> valueForm(Form<V2> valueForm) {
        return new DemandMapLaneView<K, V2>(this.agentContext, this.keyForm, valueForm, this.typesafeObservers(this.observers));
    }

    public <V2> DemandMapLaneView<K, V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    public void setValueForm(Form<V> valueForm) {
        this.valueForm = valueForm;
    }

    protected Object typesafeObservers(Object observers) {
        return observers;
    }

    public final boolean isSigned() {
        return false;
    }

    public DemandMapLaneView<K, V> isSigned(boolean isSigned) {
        return this;
    }

    @Override
    public void close() {
        this.laneBinding.closeLaneView(this);
    }

    @Override
    public DemandMapLaneView<K, V> observe(Object observer) {
        return (DemandMapLaneView)super.observe(observer);
    }

    @Override
    public DemandMapLaneView<K, V> unobserve(Object observer) {
        return (DemandMapLaneView)super.unobserve(observer);
    }

    public DemandMapLaneView<K, V> onCue(OnCueKey<K, V> onCue) {
        return this.observe(onCue);
    }

    public DemandMapLaneView<K, V> onSync(OnSyncMap<K, V> onSync) {
        return this.observe(onSync);
    }

    @Override
    public DemandMapLaneView<K, V> willCommand(WillCommand willCommand) {
        return this.observe(willCommand);
    }

    @Override
    public DemandMapLaneView<K, V> didCommand(DidCommand didCommand) {
        return this.observe(didCommand);
    }

    @Override
    public DemandMapLaneView<K, V> willUplink(WillUplink willUplink) {
        return this.observe(willUplink);
    }

    @Override
    public DemandMapLaneView<K, V> didUplink(DidUplink didUplink) {
        return this.observe(didUplink);
    }

    @Override
    public DemandMapLaneView<K, V> willEnter(WillEnter willEnter) {
        return this.observe(willEnter);
    }

    @Override
    public DemandMapLaneView<K, V> didEnter(DidEnter didEnter) {
        return this.observe(didEnter);
    }

    @Override
    public DemandMapLaneView<K, V> willLeave(WillLeave willLeave) {
        return this.observe(willLeave);
    }

    @Override
    public DemandMapLaneView<K, V> didLeave(DidLeave didLeave) {
        return this.observe(didLeave);
    }

    @Override
    public DemandMapLaneView<K, V> decodeRequest(DecodeRequestHttp<Object> decodeRequest) {
        return this.observe(decodeRequest);
    }

    @Override
    public DemandMapLaneView<K, V> willRequest(WillRequestHttp<?> willRequest) {
        return this.observe(willRequest);
    }

    @Override
    public DemandMapLaneView<K, V> didRequest(DidRequestHttp<Object> didRequest) {
        return this.observe(didRequest);
    }

    @Override
    public DemandMapLaneView<K, V> doRespond(DoRespondHttp<Object> doRespond) {
        return this.observe(doRespond);
    }

    @Override
    public DemandMapLaneView<K, V> willRespond(WillRespondHttp<?> willRespond) {
        return this.observe(willRespond);
    }

    @Override
    public DemandMapLaneView<K, V> didRespond(DidRespondHttp<?> didRespond) {
        return this.observe(didRespond);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected V dispatchOnCue(K key, Uplink uplink) {
        Lane lane = SwimContext.getLane();
        Link link = SwimContext.getLink();
        SwimContext.setLane((Lane)this);
        SwimContext.setLink((Link)uplink);
        try {
            block14: {
                Object observers = this.observers;
                if (observers instanceof OnCueKey) {
                    Object object;
                    try {
                        Object value = ((OnCueKey)observers).onCue(key, uplink);
                        if (value == null) break block14;
                        object = value;
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                            break block14;
                        }
                        throw error;
                    }
                    return (V)object;
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        Object object;
                        if (!(observer instanceof OnCueKey)) continue;
                        try {
                            Object value = ((OnCueKey)observer).onCue(key, uplink);
                            if (value == null) continue;
                            object = value;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                                continue;
                            }
                            throw error;
                        }
                        return (V)object;
                    }
                }
            }
            V v = null;
            return v;
        }
        finally {
            SwimContext.setLink((Link)link);
            SwimContext.setLane((Lane)lane);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator<Map.Entry<K, V>> dispatchOnSync(Uplink uplink) {
        Lane oldLane = SwimContext.getLane();
        Link oldLink = SwimContext.getLink();
        SwimContext.setLane((Lane)this);
        SwimContext.setLink((Link)uplink);
        try {
            block15: {
                Object observers = this.observers;
                if (observers instanceof OnSyncMap) {
                    try {
                        Iterator iterator = ((OnSyncMap)observers).onSync(uplink);
                        if (iterator != null) {
                            Iterator iterator2 = iterator;
                            return iterator2;
                        }
                        break block15;
                    }
                    catch (Throwable error) {
                        if (Conts.isNonFatal((Throwable)error)) {
                            this.laneDidFail(error);
                            break block15;
                        }
                        throw error;
                    }
                }
                if (observers instanceof Object[]) {
                    for (Object observer : (Object[])observers) {
                        if (!(observer instanceof OnSyncMap)) continue;
                        try {
                            Iterator iterator = ((OnSyncMap)observer).onSync(uplink);
                            if (iterator == null) continue;
                            Iterator iterator3 = iterator;
                            return iterator3;
                        }
                        catch (Throwable error) {
                            if (Conts.isNonFatal((Throwable)error)) {
                                this.laneDidFail(error);
                                continue;
                            }
                            throw error;
                        }
                    }
                }
            }
            Iterator<Map.Entry<K, V>> iterator = null;
            return iterator;
        }
        finally {
            SwimContext.setLink((Link)oldLink);
            SwimContext.setLane((Lane)oldLane);
        }
    }

    Value nextDownCue(Value key, Uplink uplink) {
        Object keyObject = this.keyForm.cast((Item)key);
        V object = this.dispatchOnCue(keyObject, uplink);
        if (object != null) {
            return this.valueForm.mold(object).toValue();
        }
        return null;
    }

    Iterator<Map.Entry<Value, Value>> syncKeys(Uplink uplink) {
        Iterator iterator = this.dispatchOnSync(uplink);
        if (iterator != null) {
            if (this.keyForm == Form.forValue() && this.valueForm == Form.forValue()) {
                return iterator;
            }
            return new DemandMapLaneIterator(iterator, this.keyForm, this.valueForm);
        }
        return null;
    }

    public void cue(K key) {
        this.laneBinding.cueDownKey(this.keyForm.mold(key).toValue());
    }

    public void remove(K key) {
        this.laneBinding.remove(this.keyForm.mold(key).toValue());
    }
}

