/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import java.util.Map;
import swim.api.downlink.ValueDownlink;
import swim.runtime.lane.JoinValueLaneDownlink;
import swim.runtime.lane.JoinValueLaneModel;
import swim.runtime.lane.JoinValueLaneView;
import swim.runtime.lane.LaneRelay;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;

final class JoinValueLaneRelayDownlink
extends LaneRelay<JoinValueLaneModel, JoinValueLaneView<?, ?>> {
    Form<Object> keyForm;
    final Value key;
    Object keyObject;
    JoinValueLaneDownlink<Object> downlink;

    JoinValueLaneRelayDownlink(JoinValueLaneModel model, Value key, JoinValueLaneDownlink<?> downlink) {
        super(model, 0, 2);
        this.key = key;
        this.downlink = downlink;
    }

    @Override
    void beginPhase(int phase) {
        if (phase == 1) {
            ((JoinValueLaneModel)this.model).openDownlink(this.key, this.downlink);
        }
    }

    @Override
    boolean runPhase(JoinValueLaneView<?, ?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            Form keyForm = view.keyForm;
            if (this.keyForm != keyForm && keyForm != null) {
                this.keyForm = keyForm;
                this.keyObject = keyForm.cast((Item)this.key);
                if (this.keyObject == null) {
                    this.keyObject = keyForm.unit();
                }
            }
            if (preemptive) {
                this.downlink = (JoinValueLaneDownlink)view.laneWillDownlink(this.keyObject, this.downlink);
            }
            Map.Entry<Boolean, ValueDownlink<Object>> result = view.dispatchWillDownlink(this.keyObject, this.downlink, preemptive);
            this.downlink = (JoinValueLaneDownlink)result.getValue();
            return result.getKey();
        }
        if (phase == 1) {
            Form keyForm = view.keyForm;
            if (this.keyForm != keyForm && keyForm != null) {
                this.keyForm = keyForm;
                this.keyObject = keyForm.cast((Item)this.key);
                if (this.keyObject == null) {
                    this.keyObject = keyForm.unit();
                }
            }
            if (preemptive) {
                view.laneDidDownlink(this.keyObject, this.downlink);
            }
            return view.dispatchDidDownlink(this.keyObject, this.downlink, preemptive);
        }
        throw new AssertionError();
    }
}

