/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import swim.http.HttpBody;
import swim.http.HttpEntity;
import swim.http.HttpRequest;
import swim.http.HttpResponse;
import swim.http.HttpStatus;
import swim.runtime.lane.HttpLaneUplink;
import swim.runtime.lane.LaneModel;
import swim.runtime.lane.LaneRelay;
import swim.runtime.lane.LaneView;

final class LaneRelayDoRespondHttp<View extends LaneView>
extends LaneRelay<LaneModel<View, ?>, View> {
    final HttpLaneUplink uplink;
    final HttpRequest<Object> request;
    HttpResponse<?> response;

    LaneRelayDoRespondHttp(LaneModel<View, ?> model, HttpLaneUplink uplink, HttpRequest<Object> request) {
        super(model);
        this.uplink = uplink;
        this.request = request;
    }

    @Override
    boolean runPhase(View view, int phase, boolean preemptive) {
        if (phase == 0) {
            boolean complete;
            Object response = this.response;
            if (response == null) {
                response = ((LaneView)view).dispatchDoRespond(this.uplink, this.request, preemptive);
            }
            boolean bl = complete = response == Boolean.TRUE;
            if (complete) {
                response = ((LaneView)view).laneDoRespond(this.uplink, this.request);
            }
            if (response instanceof HttpResponse) {
                this.response = response;
                return true;
            }
            return complete;
        }
        throw new AssertionError();
    }

    @Override
    void done() {
        if (this.response == null) {
            this.response = HttpResponse.from((HttpStatus)HttpStatus.NOT_FOUND).entity((HttpEntity)HttpBody.empty());
        }
        this.uplink.writeResponse(this.response);
    }
}

