/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import swim.concurrent.Stage;
import swim.runtime.LinkBinding;
import swim.runtime.lane.ListLaneModel;
import swim.runtime.uplink.ListOperation;
import swim.runtime.uplink.SeqUplinkModem;
import swim.structure.Attr;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.warp.SyncRequest;

public class ListLaneUplink
extends SeqUplinkModem {
    final ListLaneModel laneBinding;

    public ListLaneUplink(ListLaneModel laneBinding, LinkBinding linkBinding) {
        super(linkBinding);
        this.laneBinding = laneBinding;
    }

    @Override
    public ListLaneModel laneBinding() {
        return this.laneBinding;
    }

    @Override
    public Stage stage() {
        return this.laneBinding.stage();
    }

    @Override
    protected Value nextDownKey(Value key, ListOperation listOperation) {
        int index = key.get("index").intValue();
        Value listKey = key.get("key");
        Record header = Record.create((int)2).slot("key", listKey).slot("index", index);
        switch (listOperation) {
            case UPDATE: {
                Value value;
                try {
                    value = (Value)this.laneBinding.data.get(index, (Object)listKey);
                }
                catch (Exception e) {
                    value = null;
                }
                if (value != null) {
                    return Attr.of((String)"update", (Value)header).concat((Item)value);
                }
                return null;
            }
            case REMOVE: {
                return Record.create((int)1).attr("remove", (Value)header);
            }
            case MOVE: {
                return Record.create((int)1).attr("move", (Value)header);
            }
        }
        return null;
    }

    @Override
    protected void willSync(SyncRequest request) {
        this.syncDown(this.laneBinding.iterator());
        super.willSync(request);
    }
}

