/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import swim.api.Link;
import swim.runtime.lane.LaneRelay;
import swim.runtime.lane.MapLaneModel;
import swim.runtime.lane.MapLaneView;
import swim.structure.Record;
import swim.structure.Value;
import swim.warp.CommandMessage;

final class MapLaneRelayDrop
extends LaneRelay<MapLaneModel, MapLaneView<?, ?>> {
    final Link link;
    final CommandMessage message;
    final int lower;

    MapLaneRelayDrop(MapLaneModel model, Link link, CommandMessage message, int lower) {
        super(model, 0, 4);
        this.link = link;
        this.message = message;
        this.lower = lower;
    }

    MapLaneRelayDrop(MapLaneModel model, Link link, int lower) {
        super(model, 1, 3);
        this.link = link;
        this.message = null;
        this.lower = lower;
    }

    @Override
    void beginPhase(int phase) {
        if (phase == 2) {
            ((MapLaneModel)this.model).data.drop(this.lower);
        }
    }

    @Override
    boolean runPhase(MapLaneView<?, ?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.laneWillCommand(this.message);
            }
            return view.dispatchWillCommand(this.message.body(), preemptive);
        }
        if (phase == 1) {
            if (preemptive) {
                view.laneWillDrop(this.lower);
            }
            return view.dispatchWillDrop(this.link, this.lower, preemptive);
        }
        if (phase == 2) {
            if (preemptive) {
                view.laneDidDrop(this.lower);
            }
            return view.dispatchDidDrop(this.link, this.lower, preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.laneDidCommand(this.message);
            }
            return view.dispatchDidCommand(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    void done() {
        ((MapLaneModel)this.model).sendDown((Value)Record.create((int)1).attr("drop", this.lower));
    }
}

