/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import java.util.Map;
import swim.api.Link;
import swim.runtime.lane.LaneRelay;
import swim.runtime.lane.ValueLaneModel;
import swim.runtime.lane.ValueLaneView;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;
import swim.warp.CommandMessage;

final class ValueLaneRelaySet
extends LaneRelay<ValueLaneModel, ValueLaneView<?>> {
    final Link link;
    final CommandMessage message;
    Form<Object> valueForm;
    Value oldValue;
    Object oldObject;
    Value newValue;
    Object newObject;

    ValueLaneRelaySet(ValueLaneModel model, Link link, CommandMessage message, Value newValue) {
        super(model, 4);
        this.link = link;
        this.message = message;
        this.newValue = newValue;
    }

    ValueLaneRelaySet(ValueLaneModel model, Link link, Value newValue) {
        super(model, 1, 3);
        this.link = link;
        this.message = null;
        this.newValue = newValue;
    }

    @Override
    void beginPhase(int phase) {
        if (phase == 2) {
            this.oldValue = (Value)((ValueLaneModel)this.model).data.set((Object)this.newValue);
            if (this.valueForm != null) {
                this.oldObject = this.valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = this.valueForm.unit();
                }
            }
        }
    }

    @Override
    boolean runPhase(ValueLaneView<?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.laneWillCommand(this.message);
            }
            return view.dispatchWillCommand(this.message.body(), preemptive);
        }
        if (phase == 1) {
            Form valueForm = view.valueForm;
            if (this.valueForm != valueForm && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.newValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
            }
            if (preemptive) {
                this.newObject = view.laneWillSet(this.oldObject);
            }
            Map.Entry<Boolean, Object> result = view.dispatchWillSet(this.link, this.oldObject, preemptive);
            this.newObject = result.getValue();
            if (this.oldObject != this.newObject) {
                this.newValue = valueForm.mold(this.newObject).toValue();
            }
            return result.getKey();
        }
        if (phase == 2) {
            Form valueForm = view.valueForm;
            if (this.valueForm != valueForm && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
                this.newObject = valueForm.cast((Item)this.newValue);
                if (this.newObject == null) {
                    this.newObject = valueForm.unit();
                }
            }
            if (preemptive) {
                view.laneDidSet(this.newObject, this.oldObject);
            }
            return view.dispatchDidSet(this.link, this.newObject, this.oldObject, preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.laneDidCommand(this.message);
            }
            return view.dispatchDidCommand(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    void done() {
        ((ValueLaneModel)this.model).cueDown();
    }
}

