/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.scope;

import swim.api.downlink.EventDownlink;
import swim.api.downlink.ListDownlink;
import swim.api.downlink.MapDownlink;
import swim.api.downlink.ValueDownlink;
import swim.api.http.HttpDownlink;
import swim.api.ref.LaneRef;
import swim.concurrent.Stage;
import swim.runtime.CellContext;
import swim.runtime.downlink.EventDownlinkView;
import swim.runtime.downlink.ListDownlinkView;
import swim.runtime.downlink.MapDownlinkView;
import swim.runtime.downlink.ValueDownlinkView;
import swim.runtime.scope.Scope;
import swim.runtime.scope.ScopePushRequest;
import swim.structure.Form;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.CommandMessage;
import swim.warp.Envelope;

public class LaneScope
extends Scope
implements LaneRef {
    protected final Uri meshUri;
    protected final Uri hostUri;
    protected final Uri nodeUri;
    protected final Uri laneUri;

    public LaneScope(CellContext cellContext, Stage stage, Uri meshUri, Uri hostUri, Uri nodeUri, Uri laneUri) {
        super(cellContext, stage);
        this.meshUri = meshUri;
        this.hostUri = hostUri;
        this.nodeUri = nodeUri;
        this.laneUri = laneUri;
    }

    @Override
    public final Uri meshUri() {
        return this.meshUri;
    }

    public final Uri hostUri() {
        return this.hostUri;
    }

    public final Uri nodeUri() {
        return this.nodeUri;
    }

    public final Uri laneUri() {
        return this.laneUri;
    }

    public EventDownlink<Value> downlink() {
        return new EventDownlinkView<Value>(this, this.stage, this.meshUri, this.hostUri, this.nodeUri, this.laneUri, 0.0f, 0.0f, Value.absent(), Form.forValue());
    }

    public ListDownlink<Value> downlinkList() {
        return new ListDownlinkView<Value>(this, this.stage, this.meshUri, this.hostUri, this.nodeUri, this.laneUri, 0.0f, 0.0f, Value.absent(), Form.forValue());
    }

    public MapDownlink<Value, Value> downlinkMap() {
        return new MapDownlinkView<Value, Value>((CellContext)this, this.stage, this.meshUri, this.hostUri, this.nodeUri, this.laneUri, 0.0f, 0.0f, Value.absent(), Form.forValue(), Form.forValue());
    }

    public ValueDownlink<Value> downlinkValue() {
        return new ValueDownlinkView<Value>(this, this.stage, this.meshUri, this.hostUri, this.nodeUri, this.laneUri, 0.0f, 0.0f, Value.absent(), Form.forValue());
    }

    public <T> HttpDownlink<T> downlinkHttp() {
        return null;
    }

    public void command(float prio, Value body) {
        CommandMessage message = new CommandMessage(this.nodeUri, this.laneUri, body);
        this.pushDown(new ScopePushRequest(this.meshUri, this.hostUri, null, (Envelope)message, prio));
    }

    public void command(Value body) {
        this.command(0.0f, body);
    }
}

