/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.uplink;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import swim.api.auth.Identity;
import swim.collections.FingerTrieSeq;
import swim.runtime.LinkBinding;
import swim.runtime.LinkContext;
import swim.structure.Value;
import swim.warp.Envelope;
import swim.warp.UnlinkedResponse;

public class ErrorUplinkModem
implements LinkContext {
    protected final LinkBinding linkBinding;
    protected final Value body;
    volatile int status;
    static final int FEEDING_DOWN = 1;
    static final AtomicIntegerFieldUpdater<ErrorUplinkModem> STATUS = AtomicIntegerFieldUpdater.newUpdater(ErrorUplinkModem.class, "status");

    public ErrorUplinkModem(LinkBinding linkBinding, Value body) {
        this.linkBinding = linkBinding;
        this.body = body;
    }

    @Override
    public Value linkKey() {
        return Value.absent();
    }

    @Override
    public boolean isConnectedUp() {
        return true;
    }

    @Override
    public boolean isRemoteUp() {
        return false;
    }

    @Override
    public boolean isSecureUp() {
        return true;
    }

    @Override
    public String securityProtocolUp() {
        return null;
    }

    @Override
    public String cipherSuiteUp() {
        return null;
    }

    @Override
    public InetSocketAddress localAddressUp() {
        return null;
    }

    @Override
    public Identity localIdentityUp() {
        return null;
    }

    @Override
    public Principal localPrincipalUp() {
        return null;
    }

    @Override
    public Collection<Certificate> localCertificatesUp() {
        return FingerTrieSeq.empty();
    }

    @Override
    public InetSocketAddress remoteAddressUp() {
        return null;
    }

    @Override
    public Identity remoteIdentityUp() {
        return null;
    }

    @Override
    public Principal remotePrincipalUp() {
        return null;
    }

    @Override
    public Collection<Certificate> remoteCertificatesUp() {
        return FingerTrieSeq.empty();
    }

    public void cueDown() {
        int newStatus;
        int oldStatus;
        while ((oldStatus = this.status) != (newStatus = oldStatus | 1) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if (oldStatus != newStatus) {
            this.linkBinding.feedDown();
        }
    }

    @Override
    public void pullDown() {
        int newStatus;
        int oldStatus;
        while ((oldStatus = this.status) != (newStatus = oldStatus & 0xFFFFFFFE) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if (oldStatus != newStatus) {
            UnlinkedResponse response = this.getUnlinkedResponse();
            this.linkBinding.pushDown((Envelope)response);
        } else {
            this.linkBinding.skipDown();
        }
    }

    @Override
    public void feedUp() {
    }

    @Override
    public void pushUp(Envelope envelope) {
    }

    @Override
    public void skipUp() {
    }

    @Override
    public void closeUp() {
    }

    @Override
    public void didOpenDown() {
    }

    @Override
    public void didCloseDown() {
    }

    protected UnlinkedResponse getUnlinkedResponse() {
        return new UnlinkedResponse(this.linkBinding.nodeUri(), this.linkBinding.laneUri(), this.body);
    }

    @Override
    public void traceUp(Object message) {
    }

    @Override
    public void debugUp(Object message) {
    }

    @Override
    public void infoUp(Object message) {
    }

    @Override
    public void warnUp(Object message) {
    }

    @Override
    public void errorUp(Object message) {
    }
}

