/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.math.BigInteger;
import swim.security.EcCharacteristic2FieldDef;
import swim.security.EcFieldDef;
import swim.security.EcPrimeFieldDef;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;

final class EcFieldForm
extends Form<EcFieldDef> {
    EcFieldForm() {
    }

    public String tag() {
        return "ECField";
    }

    public Class<?> type() {
        return EcFieldDef.class;
    }

    public Item mold(EcFieldDef fieldDef) {
        return fieldDef.toValue();
    }

    public EcFieldDef cast(Item item) {
        Value value = item.toValue();
        Value header = value.getAttr(this.tag());
        if (header.isDefined()) {
            BigInteger prime = value.get("prime").integerValue(null);
            if (prime != null) {
                return new EcPrimeFieldDef(prime);
            }
            int size = header.get("size").intValue(0);
            BigInteger basis = value.get("basis").integerValue(null);
            if (size > 0 && basis != null) {
                return new EcCharacteristic2FieldDef(size, basis);
            }
        }
        return null;
    }
}

