/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.math.BigInteger;
import java.security.spec.ECPoint;
import swim.security.EcPointForm;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public class EcPointDef {
    protected final BigInteger x;
    protected final BigInteger y;
    private static int hashSeed;
    private static Form<EcPointDef> form;

    public EcPointDef(BigInteger x, BigInteger y) {
        this.x = x;
        this.y = y;
    }

    public final BigInteger x() {
        return this.x;
    }

    public final BigInteger y() {
        return this.y;
    }

    public final ECPoint toECPoint() {
        return new ECPoint(this.x, this.y);
    }

    public Value toValue() {
        return EcPointDef.form().mold((Object)this).toValue();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof EcPointDef) {
            EcPointDef that = (EcPointDef)other;
            return this.x.equals(that.x) && this.y.equals(that.y);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(EcPointDef.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.x.hashCode()), (int)this.y.hashCode()));
    }

    public static EcPointDef from(ECPoint point) {
        return new EcPointDef(point.getAffineX(), point.getAffineY());
    }

    @Kind
    public static Form<EcPointDef> form() {
        if (form == null) {
            form = new EcPointForm();
        }
        return form;
    }
}

