/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import swim.security.EcPrivateKeyDef;
import swim.security.KeyDef;
import swim.security.PrivateKeyForm;
import swim.security.RsaPrivateKeyDef;
import swim.structure.Form;
import swim.structure.Kind;

public abstract class PrivateKeyDef
extends KeyDef {
    private static Form<PrivateKeyDef> privateKeyForm;

    public abstract PrivateKey privateKey();

    public static PrivateKeyDef from(PrivateKey key) {
        if (key instanceof ECPrivateKey) {
            return EcPrivateKeyDef.from((ECPrivateKey)key);
        }
        if (key instanceof RSAPrivateKey) {
            return RsaPrivateKeyDef.from((RSAPrivateKey)key);
        }
        throw new IllegalArgumentException(key.toString());
    }

    @Kind
    public static Form<PrivateKeyDef> privateKeyForm() {
        if (privateKeyForm == null) {
            privateKeyForm = new PrivateKeyForm();
        }
        return privateKeyForm;
    }
}

