/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.math.BigInteger;
import java.security.spec.RSAOtherPrimeInfo;
import swim.security.RsaPrimeForm;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.util.Murmur3;

public class RsaPrimeDef {
    protected final BigInteger factor;
    protected final BigInteger exponent;
    protected final BigInteger coefficient;
    private static int hashSeed;
    private static Form<RsaPrimeDef> form;

    public RsaPrimeDef(BigInteger factor, BigInteger exponent, BigInteger coefficient) {
        this.factor = factor;
        this.exponent = exponent;
        this.coefficient = coefficient;
    }

    public RsaPrimeDef(BigInteger factor, BigInteger exponent) {
        this(factor, exponent, null);
    }

    public final BigInteger factor() {
        return this.factor;
    }

    public final BigInteger exponent() {
        return this.exponent;
    }

    public final BigInteger coefficient() {
        return this.coefficient;
    }

    public final RSAOtherPrimeInfo toRSAOtherPrimeInfo() {
        return new RSAOtherPrimeInfo(this.factor, this.exponent, this.coefficient);
    }

    public Value toValue() {
        return RsaPrimeDef.form().mold((Object)this).toValue();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof RsaPrimeDef) {
            RsaPrimeDef that = (RsaPrimeDef)other;
            return this.factor.equals(that.factor) && this.exponent.equals(that.exponent) && (this.coefficient == null ? that.coefficient == null : this.coefficient.equals(that.coefficient));
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(RsaPrimeDef.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.factor.hashCode()), (int)this.exponent.hashCode()), (int)Murmur3.hash((Number)this.coefficient)));
    }

    public static RsaPrimeDef from(RSAOtherPrimeInfo info) {
        return new RsaPrimeDef(info.getPrime(), info.getExponent(), info.getCrtCoefficient());
    }

    @Kind
    public static Form<RsaPrimeDef> form() {
        if (form == null) {
            form = new RsaPrimeForm();
        }
        return form;
    }
}

