/*
 * Decompiled with CFR 0.152.
 */
package swim.security;

import java.math.BigInteger;
import swim.security.RsaPrimeDef;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Num;
import swim.structure.Record;
import swim.structure.Value;

final class RsaPrimeForm
extends Form<RsaPrimeDef> {
    RsaPrimeForm() {
    }

    public String tag() {
        return "prime";
    }

    public Class<?> type() {
        return RsaPrimeDef.class;
    }

    public Item mold(RsaPrimeDef primeDef) {
        Record header = Record.create((int)(primeDef.coefficient != null ? 3 : 2)).slot("factor", (Value)Num.from((BigInteger)primeDef.factor)).slot("exponent", (Value)Num.from((BigInteger)primeDef.exponent));
        if (primeDef.coefficient != null) {
            header.slot("coefficient", (Value)Num.from((BigInteger)primeDef.coefficient));
        }
        return Record.create((int)1).attr(this.tag(), (Value)header);
    }

    public RsaPrimeDef cast(Item item) {
        Value header = item.toValue().header(this.tag());
        if (header.isDefined()) {
            BigInteger factor = header.get("factor").integerValue(null);
            BigInteger exponent = header.get("exponent").integerValue(null);
            BigInteger coefficient = header.get("coefficient").integerValue(null);
            if (factor != null && exponent != null) {
                return new RsaPrimeDef(factor, exponent, coefficient);
            }
        }
        return null;
    }
}

