/*
 * Decompiled with CFR 0.152.
 */
package swim.spatial;

import java.util.Iterator;
import java.util.Map;

public interface SpatialMap<K, S, V>
extends Iterable<Entry<K, S, V>> {
    public boolean isEmpty();

    public int size();

    public boolean containsKey(K var1, S var2);

    public boolean containsKey(Object var1);

    public boolean containsValue(Object var1);

    public V get(K var1, S var2);

    public V get(Object var1);

    public V put(K var1, S var2, V var3);

    public V move(K var1, S var2, S var3, V var4);

    public V remove(K var1, S var2);

    public void clear();

    public Iterator<Entry<K, S, V>> iterator(S var1);

    public Iterator<K> keyIterator();

    public Iterator<V> valueIterator();

    public static class SimpleEntry<K, S, V>
    implements Entry<K, S, V> {
        protected K key;
        protected S shape;
        protected V value;

        public SimpleEntry(K key, S shape, V value) {
            this.key = key;
            this.shape = shape;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public S getShape() {
            return this.shape;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof Map.Entry) {
                Map.Entry that = (Map.Entry)other;
                K key = this.getKey();
                if (key == null ? that.getKey() != null : !key.equals(that.getKey())) {
                    return false;
                }
                V value = this.getValue();
                return !(value == null ? that.getValue() != null : !value.equals(that.getValue()));
            }
            return false;
        }

        @Override
        public int hashCode() {
            K key = this.getKey();
            V value = this.getValue();
            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public String toString() {
            return "" + this.getKey() + '=' + this.getValue();
        }
    }

    public static interface Entry<K, S, V>
    extends Map.Entry<K, V> {
        public S getShape();
    }
}

