/*
 * Decompiled with CFR 0.152.
 */
package swim.spatial;

import java.util.Iterator;
import swim.spatial.SpatialMap;
import swim.spatial.SpatialValueEntryIterator;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;
import swim.structure.collections.ValueIterator;

public class SpatialValueMap<K, S, V>
implements SpatialMap<K, S, V> {
    protected SpatialMap<Value, S, Value> inner;
    protected Form<K> keyForm;
    protected Form<V> valueForm;

    public SpatialValueMap(SpatialMap<Value, S, Value> inner, Form<K> keyForm, Form<V> valueForm) {
        this.inner = inner;
        this.keyForm = keyForm;
        this.valueForm = valueForm;
    }

    public SpatialMap<Value, S, Value> inner() {
        return this.inner;
    }

    public Form<K> keyForm() {
        return this.keyForm;
    }

    public <K2> SpatialValueMap<K2, S, V> keyForm(Form<K2> keyForm) {
        return new SpatialValueMap<K2, S, V>(this.inner, keyForm, this.valueForm);
    }

    public <K2> SpatialValueMap<K2, S, V> keyClass(Class<K2> keyClass) {
        return this.keyForm(Form.forClass(keyClass));
    }

    public Form<V> valueForm() {
        return this.valueForm;
    }

    public <V2> SpatialValueMap<K, S, V2> valueForm(Form<V2> valueForm) {
        return new SpatialValueMap<K, S, V2>(this.inner, this.keyForm, valueForm);
    }

    public <V2> SpatialValueMap<K, S, V2> valueClass(Class<V2> valueClass) {
        return this.valueForm(Form.forClass(valueClass));
    }

    @Override
    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public boolean containsKey(K keyObject, S shape) {
        Value key = this.keyForm.mold(keyObject).toValue();
        return this.inner.containsKey(key, shape);
    }

    @Override
    public boolean containsKey(Object keyObject) {
        Class keyType = this.keyForm.type();
        if (keyType == null || keyType.isInstance(keyObject)) {
            Value key = this.keyForm.mold(keyObject).toValue();
            return this.inner.containsKey(key);
        }
        return false;
    }

    @Override
    public boolean containsValue(Object valueObject) {
        Class valueType = this.valueForm.type();
        if (valueType == null || valueType.isInstance(valueObject)) {
            Value value = this.valueForm.mold(valueObject).toValue();
            return this.inner.containsValue(value);
        }
        return false;
    }

    @Override
    public V get(K keyObject, S shape) {
        Value key = this.keyForm.mold(keyObject).toValue();
        Value value = this.inner.get(key, shape);
        Object valueObject = this.valueForm.cast((Item)value);
        if (valueObject != null) {
            return (V)valueObject;
        }
        return (V)this.valueForm.unit();
    }

    @Override
    public V get(Object keyObject) {
        Value key;
        Value value;
        Object valueObject;
        Class keyType = this.keyForm.type();
        if ((keyType == null || keyType.isInstance(keyObject)) && (valueObject = this.valueForm.cast((Item)(value = this.inner.get(key = this.keyForm.mold(keyObject).toValue())))) != null) {
            return (V)valueObject;
        }
        return (V)this.valueForm.unit();
    }

    @Override
    public V put(K keyObject, S shape, V newObject) {
        Value newValue;
        Value key = this.keyForm.mold(keyObject).toValue();
        Value oldValue = this.inner.put(key, shape, newValue = this.valueForm.mold(newObject).toValue());
        Object oldObject = this.valueForm.cast((Item)oldValue);
        if (oldObject != null) {
            return (V)oldObject;
        }
        return (V)this.valueForm.unit();
    }

    @Override
    public V move(K keyObject, S oldShape, S newShape, V newObject) {
        Value newValue;
        Value key = this.keyForm.mold(keyObject).toValue();
        Value oldValue = this.inner.move(key, oldShape, newShape, newValue = this.valueForm.mold(newObject).toValue());
        Object oldObject = this.valueForm.cast((Item)oldValue);
        if (oldObject != null) {
            return (V)oldObject;
        }
        return (V)this.valueForm.unit();
    }

    @Override
    public V remove(K keyObject, S shape) {
        Value key = this.keyForm.mold(keyObject).toValue();
        Value oldValue = this.inner.remove(key, shape);
        Object oldObject = this.valueForm.cast((Item)oldValue);
        if (oldObject != null) {
            return (V)oldObject;
        }
        return (V)this.valueForm.unit();
    }

    @Override
    public void clear() {
        this.inner.clear();
    }

    @Override
    public Iterator<SpatialMap.Entry<K, S, V>> iterator(S shape) {
        if (this.keyForm != Form.forValue() || this.valueForm != Form.forValue()) {
            return new SpatialValueEntryIterator<K, S, V>(this.inner.iterator(shape), this.keyForm, this.valueForm);
        }
        return this.inner.iterator(shape);
    }

    @Override
    public Iterator<SpatialMap.Entry<K, S, V>> iterator() {
        if (this.keyForm != Form.forValue() || this.valueForm != Form.forValue()) {
            return new SpatialValueEntryIterator(this.inner.iterator(), this.keyForm, this.valueForm);
        }
        return this.inner.iterator();
    }

    @Override
    public Iterator<K> keyIterator() {
        if (this.keyForm != Form.forValue() || this.valueForm != Form.forValue()) {
            return new ValueIterator(this.inner.keyIterator(), this.keyForm);
        }
        return this.inner.keyIterator();
    }

    @Override
    public Iterator<V> valueIterator() {
        if (this.keyForm != Form.forValue() || this.valueForm != Form.forValue()) {
            return new ValueIterator(this.inner.valueIterator(), this.valueForm);
        }
        return this.inner.valueIterator();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SpatialMap) {
            SpatialMap that = (SpatialMap)other;
            if (this.size() != that.size()) {
                return false;
            }
            try {
                for (SpatialMap.Entry<K, S, V> entry : this) {
                    Object keyObject = entry.getKey();
                    Object valueObject = entry.getValue();
                    if (!(valueObject != null ? !valueObject.equals(that.get(keyObject)) : that.get(keyObject) != null || !that.containsKey(keyObject))) continue;
                    return false;
                }
                return true;
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        Iterator<SpatialMap.Entry<K, S, V>> these = this.iterator();
        int h = 0;
        while (these.hasNext()) {
            h += these.next().hashCode();
        }
        return h;
    }

    public String toString() {
        Iterator<SpatialMap.Entry<K, S, V>> these = this.iterator();
        if (!these.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            sb.append(these.next());
            if (!these.hasNext()) break;
            sb.append(", ");
        }
        return sb.append('}').toString();
    }
}

