/*
 * Decompiled with CFR 0.152.
 */
package swim.spatial;

import java.util.Comparator;
import swim.spatial.QTreeEntry;
import swim.spatial.QTreePage;

public abstract class QTreeContext<K, S, V>
implements Comparator<QTreeEntry<K, S, V>> {
    @Override
    public int compare(QTreeEntry<K, S, V> x, QTreeEntry<K, S, V> y) {
        return this.compareKey(x.key, y.key);
    }

    protected int compareKey(K x, K y) {
        return ((Comparable)x).compareTo(y);
    }

    protected int pageSplitSize() {
        return 32;
    }

    protected boolean pageShouldSplit(QTreePage<K, S, V> page) {
        return page.arity() > this.pageSplitSize();
    }

    protected boolean pageShouldMerge(QTreePage<K, S, V> page) {
        return page.arity() < this.pageSplitSize() >>> 1;
    }
}

