/*
 * Decompiled with CFR 0.152.
 */
package swim.spatial;

import swim.math.R2ToZ2Operator;
import swim.math.Z2ToR2Operator;
import swim.spatial.GeoProjection;

final class SphericalMercatorInverse
implements Z2ToR2Operator {
    SphericalMercatorInverse() {
    }

    public double transformX(long x, long y) {
        return SphericalMercatorInverse.transformX(x);
    }

    public double transformY(long x, long y) {
        return SphericalMercatorInverse.transformY(y);
    }

    public R2ToZ2Operator inverse() {
        return GeoProjection.sphericalMercator();
    }

    static double transformX(long x) {
        return SphericalMercatorInverse.round(Math.toDegrees(SphericalMercatorInverse.unscale(x)));
    }

    static double transformY(long y) {
        return SphericalMercatorInverse.round(Math.toDegrees(Math.atan(Math.exp(SphericalMercatorInverse.unscale(y))) * 2.0 - 1.5707963267948966));
    }

    static double unscale(long x) {
        return (double)x / 9.223372036854776E18 * (Math.PI * 2) - Math.PI;
    }

    static double round(double value) {
        return (double)Math.round(value * 1.0E8) / 1.0E8;
    }
}

