/*
 * Decompiled with CFR 0.152.
 */
package swim.util;

import java.util.NoSuchElementException;
import swim.util.Cursor;

final class CursorUnary<T>
implements Cursor<T> {
    final T value;
    int index;

    CursorUnary(T value) {
        this.value = value;
        this.index = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.index != 0;
    }

    @Override
    public T head() {
        if (this.index == 0) {
            return this.value;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void step() {
        if (this.index != 0) {
            throw new UnsupportedOperationException();
        }
        this.index = 1;
    }

    @Override
    public void skip(long count) {
        this.index = (int)Math.min(Math.max(0L, (long)this.index + count), 1L);
    }

    @Override
    public boolean hasNext() {
        return this.index == 0;
    }

    @Override
    public long nextIndexLong() {
        return this.index;
    }

    @Override
    public int nextIndex() {
        return this.index;
    }

    @Override
    public T next() {
        if (this.index == 0) {
            this.index = 1;
            return this.value;
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasPrevious() {
        return this.index == 1;
    }

    @Override
    public long previousIndexLong() {
        return this.index - 1;
    }

    @Override
    public int previousIndex() {
        return this.index - 1;
    }

    @Override
    public T previous() {
        if (this.index == 1) {
            this.index = 0;
            return this.value;
        }
        throw new NoSuchElementException();
    }
}

