/*
 * Decompiled with CFR 0.152.
 */
package swim.warp;

import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.CommandMessageForm;
import swim.warp.LaneAddressed;

public final class CommandMessage
extends LaneAddressed {
    @Kind
    public static final Form<CommandMessage> FORM = new CommandMessageForm();

    public CommandMessage(Uri nodeUri, Uri laneUri, Value body) {
        super(nodeUri, laneUri, body);
    }

    public CommandMessage(Uri nodeUri, Uri laneUri) {
        this(nodeUri, laneUri, Value.absent());
    }

    public CommandMessage(String nodeUri, String laneUri, Value body) {
        this(Uri.parse((String)nodeUri), Uri.parse((String)laneUri), body);
    }

    public CommandMessage(String nodeUri, String laneUri) {
        this(Uri.parse((String)nodeUri), Uri.parse((String)laneUri), Value.absent());
    }

    @Override
    public String tag() {
        return "command";
    }

    public Form<CommandMessage> form() {
        return FORM;
    }

    @Override
    public CommandMessage nodeUri(Uri nodeUri) {
        return new CommandMessage(nodeUri, this.laneUri, this.body);
    }

    @Override
    public CommandMessage laneUri(Uri laneUri) {
        return new CommandMessage(this.nodeUri, laneUri, this.body);
    }

    @Override
    public CommandMessage body(Value body) {
        return new CommandMessage(this.nodeUri, this.laneUri, body);
    }
}

