/*
 * Decompiled with CFR 0.152.
 */
package swim.warp;

import swim.codec.Output;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Murmur3;
import swim.warp.Envelope;

public abstract class LaneAddressed
extends Envelope {
    final Uri nodeUri;
    final Uri laneUri;
    final Value body;

    LaneAddressed(Uri nodeUri, Uri laneUri, Value body) {
        this.nodeUri = nodeUri;
        this.laneUri = laneUri;
        this.body = body.commit();
    }

    @Override
    public Uri nodeUri() {
        return this.nodeUri;
    }

    @Override
    public Uri laneUri() {
        return this.laneUri;
    }

    @Override
    public Value body() {
        return this.body;
    }

    @Override
    public abstract LaneAddressed nodeUri(Uri var1);

    @Override
    public abstract LaneAddressed laneUri(Uri var1);

    @Override
    public abstract LaneAddressed body(Value var1);

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            LaneAddressed that = (LaneAddressed)other;
            return this.nodeUri.equals((Object)that.nodeUri) && this.laneUri.equals((Object)that.laneUri) && this.body.equals((Object)that.body);
        }
        return false;
    }

    public int hashCode() {
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.seed(this.getClass()), (int)this.nodeUri.hashCode()), (int)this.laneUri.hashCode()), (int)this.body.hashCode()));
    }

    @Override
    public void debug(Output<?> output) {
        output = output.write("new").write(32).write(this.getClass().getSimpleName()).write(40).debug((Object)this.nodeUri).write(", ").debug((Object)this.laneUri);
        if (this.body.isDefined()) {
            output = output.write(", ").debug((Object)this.body);
        }
        output = output.write(41);
    }
}

