/*
 * Decompiled with CFR 0.152.
 */
package swim.warp;

import swim.structure.Attr;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.LaneAddressed;

abstract class LaneAddressedForm<E extends LaneAddressed>
extends Form<E> {
    LaneAddressedForm() {
    }

    abstract E from(Uri var1, Uri var2, Value var3);

    public E unit() {
        return null;
    }

    public Item mold(E envelope) {
        if (envelope != null) {
            Record headers = Record.create((int)2).slot("node", ((LaneAddressed)envelope).nodeUri.toString()).slot("lane", ((LaneAddressed)envelope).laneUri.toString());
            return Attr.of((String)this.tag(), (Value)headers).concat((Item)((LaneAddressed)envelope).body());
        }
        return Item.extant();
    }

    public E cast(Item item) {
        Value value = item.toValue();
        Record headers = value.headers(this.tag());
        Uri nodeUri = null;
        Uri laneUri = null;
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            Item header = headers.get(i);
            String key = header.key().stringValue(null);
            if (key != null) {
                if ("node".equals(key)) {
                    nodeUri = Uri.parse((String)header.toValue().stringValue(""));
                    continue;
                }
                if (!"lane".equals(key)) continue;
                laneUri = Uri.parse((String)header.toValue().stringValue(""));
                continue;
            }
            if (!(header instanceof Value)) continue;
            if (i == 0) {
                nodeUri = Uri.parse((String)header.stringValue(""));
                continue;
            }
            if (i != 1) continue;
            laneUri = Uri.parse((String)header.stringValue(""));
        }
        if (nodeUri != null && laneUri != null) {
            Value body = value.body();
            return this.from(nodeUri, laneUri, body);
        }
        return null;
    }
}

