/*
 * Decompiled with CFR 0.152.
 */
package swim.warp;

import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.LinkAddressed;
import swim.warp.LinkRequestForm;

public final class LinkRequest
extends LinkAddressed {
    @Kind
    public static final Form<LinkRequest> FORM = new LinkRequestForm();

    public LinkRequest(Uri nodeUri, Uri laneUri, float prio, float rate, Value body) {
        super(nodeUri, laneUri, prio, rate, body);
    }

    public LinkRequest(Uri nodeUri, Uri laneUri, float prio, float rate) {
        this(nodeUri, laneUri, prio, rate, Value.absent());
    }

    public LinkRequest(Uri nodeUri, Uri laneUri, Value body) {
        this(nodeUri, laneUri, 0.0f, 0.0f, body);
    }

    public LinkRequest(Uri nodeUri, Uri laneUri) {
        this(nodeUri, laneUri, 0.0f, 0.0f, Value.absent());
    }

    public LinkRequest(String nodeUri, String laneUri, float prio, float rate, Value body) {
        this(Uri.parse((String)nodeUri), Uri.parse((String)laneUri), prio, rate, body);
    }

    public LinkRequest(String nodeUri, String laneUri, float prio, float rate) {
        this(Uri.parse((String)nodeUri), Uri.parse((String)laneUri), prio, rate, Value.absent());
    }

    public LinkRequest(String nodeUri, String laneUri, Value body) {
        this(Uri.parse((String)nodeUri), Uri.parse((String)laneUri), 0.0f, 0.0f, body);
    }

    public LinkRequest(String nodeUri, String laneUri) {
        this(Uri.parse((String)nodeUri), Uri.parse((String)laneUri), 0.0f, 0.0f, Value.absent());
    }

    @Override
    public String tag() {
        return "link";
    }

    public Form<LinkRequest> form() {
        return FORM;
    }

    @Override
    public LinkRequest nodeUri(Uri nodeUri) {
        return new LinkRequest(nodeUri, this.laneUri, this.prio, this.rate, this.body);
    }

    @Override
    public LinkRequest laneUri(Uri laneUri) {
        return new LinkRequest(this.nodeUri, laneUri, this.prio, this.rate, this.body);
    }

    @Override
    public LinkRequest body(Value body) {
        return new LinkRequest(this.nodeUri, this.laneUri, this.prio, this.rate, body);
    }
}

