/*
 * Decompiled with CFR 0.152.
 */
package swim.web.route;

import java.io.IOException;
import java.util.Collection;
import swim.http.HttpBody;
import swim.http.HttpEntity;
import swim.http.HttpResponse;
import swim.http.HttpStatus;
import swim.uri.UriPath;
import swim.web.WebRequest;
import swim.web.WebResponse;
import swim.web.WebRoute;

public final class ResourceDirectoryRoute
implements WebRoute {
    final ClassLoader classLoader;
    final UriPath directory;
    final String indexFile;

    public ResourceDirectoryRoute(ClassLoader classLoader, UriPath directory, String indexFile) {
        this.classLoader = classLoader;
        this.directory = directory;
        this.indexFile = indexFile;
    }

    @Override
    public WebResponse routeRequest(WebRequest request) {
        UriPath path = request.routePath();
        if (path.foot().isAbsolute()) {
            path = path.appended(this.indexFile);
        }
        if (path.isAbsolute()) {
            path = path.tail();
        }
        if ((path = this.directory.appended((Collection)path).removeDotSegments()).isSubpathOf(this.directory)) {
            try {
                HttpBody body = HttpBody.fromResource((ClassLoader)this.classLoader, (String)path.toString());
                if (body != null) {
                    HttpResponse response = HttpResponse.from((HttpStatus)HttpStatus.OK).content((HttpEntity)body);
                    return request.respond(response);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return request.reject();
    }
}

