/*
 * Decompiled with CFR 0.152.
 */
package swim.ws;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.WebSocketExtension;
import swim.http.WebSocketParam;
import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Murmur3;
import swim.ws.WsEngineSettingsForm;
import swim.ws.WsException;
import swim.ws.WsRequest;

public class WsEngineSettings
implements Debug {
    protected final int maxFrameSize;
    protected final int maxMessageSize;
    protected final int serverCompressionLevel;
    protected final int clientCompressionLevel;
    protected final boolean serverNoContextTakeover;
    protected final boolean clientNoContextTakeover;
    protected final int serverMaxWindowBits;
    protected final int clientMaxWindowBits;
    private static int hashSeed;
    private static WsEngineSettings standard;
    private static Form<WsEngineSettings> engineForm;

    public WsEngineSettings(int maxFrameSize, int maxMessageSize, int serverCompressionLevel, int clientCompressionLevel, boolean serverNoContextTakeover, boolean clientNoContextTakeover, int serverMaxWindowBits, int clientMaxWindowBits) {
        this.maxFrameSize = maxFrameSize;
        this.maxMessageSize = maxMessageSize;
        this.serverCompressionLevel = serverCompressionLevel;
        this.clientCompressionLevel = clientCompressionLevel;
        this.serverNoContextTakeover = serverNoContextTakeover;
        this.clientNoContextTakeover = clientNoContextTakeover;
        this.serverMaxWindowBits = serverMaxWindowBits;
        this.clientMaxWindowBits = clientMaxWindowBits;
    }

    public final int maxFrameSize() {
        return this.maxFrameSize;
    }

    public WsEngineSettings maxFrameSize(int maxFrameSize) {
        return this.copy(maxFrameSize, this.maxMessageSize, this.serverCompressionLevel, this.clientCompressionLevel, this.serverNoContextTakeover, this.clientNoContextTakeover, this.serverMaxWindowBits, this.clientMaxWindowBits);
    }

    public final int maxMessageSize() {
        return this.maxMessageSize;
    }

    public WsEngineSettings maxMessageSize(int maxMessageSize) {
        return this.copy(this.maxFrameSize, maxMessageSize, this.serverCompressionLevel, this.clientCompressionLevel, this.serverNoContextTakeover, this.clientNoContextTakeover, this.serverMaxWindowBits, this.clientMaxWindowBits);
    }

    public final int serverCompressionLevel() {
        return this.serverCompressionLevel;
    }

    public WsEngineSettings serverCompressionLevel(int serverCompressionLevel) {
        return this.copy(this.maxFrameSize, this.maxMessageSize, serverCompressionLevel, this.clientCompressionLevel, this.serverNoContextTakeover, this.clientNoContextTakeover, this.serverMaxWindowBits, this.clientMaxWindowBits);
    }

    public final int clientCompressionLevel() {
        return this.clientCompressionLevel;
    }

    public WsEngineSettings clientCompressionLevel(int clientCompressionLevel) {
        return this.copy(this.maxFrameSize, this.maxMessageSize, this.serverCompressionLevel, clientCompressionLevel, this.serverNoContextTakeover, this.clientNoContextTakeover, this.serverMaxWindowBits, this.clientMaxWindowBits);
    }

    public WsEngineSettings compressionLevel(int serverCompressionLevel, int clientCompressionLevel) {
        return this.copy(this.maxFrameSize, this.maxMessageSize, serverCompressionLevel, clientCompressionLevel, this.serverNoContextTakeover, this.clientNoContextTakeover, this.serverMaxWindowBits, this.clientMaxWindowBits);
    }

    public final boolean serverNoContextTakeover() {
        return this.serverNoContextTakeover;
    }

    public WsEngineSettings serverNoContextTakeover(boolean serverNoContextTakeover) {
        return this.copy(this.maxFrameSize, this.maxMessageSize, this.serverCompressionLevel, this.clientCompressionLevel, serverNoContextTakeover, this.clientNoContextTakeover, this.serverMaxWindowBits, this.clientMaxWindowBits);
    }

    public final boolean clientNoContextTakeover() {
        return this.clientNoContextTakeover;
    }

    public WsEngineSettings clientNoContextTakeover(boolean clientNoContextTakeover) {
        return this.copy(this.maxFrameSize, this.maxMessageSize, this.serverCompressionLevel, this.clientCompressionLevel, this.serverNoContextTakeover, clientNoContextTakeover, this.serverMaxWindowBits, this.clientMaxWindowBits);
    }

    public final int serverMaxWindowBits() {
        return this.serverMaxWindowBits;
    }

    public WsEngineSettings serverMaxWindowBits(int serverMaxWindowBits) {
        return this.copy(this.maxFrameSize, this.maxMessageSize, this.serverCompressionLevel, this.clientCompressionLevel, this.serverNoContextTakeover, this.clientNoContextTakeover, serverMaxWindowBits, this.clientMaxWindowBits);
    }

    public final int clientMaxWindowBits() {
        return this.clientMaxWindowBits;
    }

    public WsEngineSettings clientMaxWindowBits(int clientMaxWindowBits) {
        return this.copy(this.maxFrameSize, this.maxMessageSize, this.serverCompressionLevel, this.clientCompressionLevel, this.serverNoContextTakeover, this.clientNoContextTakeover, this.serverMaxWindowBits, clientMaxWindowBits);
    }

    public FingerTrieSeq<WebSocketExtension> extensions() {
        if (this.serverCompressionLevel != 0 && this.clientCompressionLevel != 0) {
            WebSocketExtension permessageDeflate = WebSocketExtension.permessageDeflate((boolean)this.serverNoContextTakeover, (boolean)this.clientNoContextTakeover, (int)this.serverMaxWindowBits, (int)0);
            return FingerTrieSeq.of((Object[])new WebSocketExtension[]{permessageDeflate});
        }
        return FingerTrieSeq.empty();
    }

    public FingerTrieSeq<WebSocketExtension> acceptExtensions(FingerTrieSeq<WebSocketExtension> requestExtensions) {
        WebSocketExtension permessageDeflate = null;
        for (WebSocketExtension extension : requestExtensions) {
            if (!"permessage-deflate".equals(extension.name()) || permessageDeflate != null || this.serverCompressionLevel == 0 || this.clientCompressionLevel == 0) continue;
            boolean requestServerNoContextTakeover = false;
            boolean requestClientNoContextTakeover = false;
            int requestServerMaxWindowBits = 15;
            int requestClientMaxWindowBits = 15;
            for (WebSocketParam param : extension.params()) {
                String key = param.key();
                String value = param.value();
                if ("server_no_context_takeover".equals(key)) {
                    requestServerNoContextTakeover = true;
                    continue;
                }
                if ("client_no_context_takeover".equals(key)) {
                    requestClientNoContextTakeover = true;
                    continue;
                }
                if ("server_max_window_bits".equals(key)) {
                    try {
                        requestServerMaxWindowBits = Integer.parseInt(value);
                        continue;
                    }
                    catch (NumberFormatException error) {
                        throw new WsException("invalid permessage-deflate; " + param.toHttp());
                    }
                }
                if ("client_max_window_bits".equals(key)) {
                    if (value.isEmpty()) {
                        requestClientMaxWindowBits = 0;
                        continue;
                    }
                    try {
                        requestClientMaxWindowBits = Integer.parseInt(value);
                        continue;
                    }
                    catch (NumberFormatException error) {
                        throw new WsException("invalid permessage-deflate; " + param.toHttp());
                    }
                }
                throw new WsException("invalid permessage-deflate; " + param.toHttp());
            }
            if (requestClientMaxWindowBits != 0 && this.clientMaxWindowBits != 15) continue;
            if (requestClientMaxWindowBits == 0) {
                requestClientMaxWindowBits = this.clientMaxWindowBits;
            }
            permessageDeflate = WebSocketExtension.permessageDeflate((requestServerNoContextTakeover || this.serverNoContextTakeover ? 1 : 0) != 0, (requestClientNoContextTakeover || this.clientNoContextTakeover ? 1 : 0) != 0, (int)Math.min(requestServerMaxWindowBits, this.serverMaxWindowBits), (int)Math.min(requestClientMaxWindowBits, this.clientMaxWindowBits));
        }
        FingerTrieSeq responseExtensions = FingerTrieSeq.empty();
        if (permessageDeflate != null) {
            responseExtensions = responseExtensions.appended(permessageDeflate);
        }
        return responseExtensions;
    }

    public WsRequest handshakeRequest(Uri uri, FingerTrieSeq<String> protocols, FingerTrieSeq<HttpHeader> headers) {
        return WsRequest.from(uri, protocols, this.extensions(), headers);
    }

    public WsRequest handshakeRequest(Uri uri, FingerTrieSeq<String> protocols, HttpHeader ... headers) {
        return this.handshakeRequest(uri, protocols, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public WsRequest handshakeRequest(Uri uri, FingerTrieSeq<String> protocols) {
        return this.handshakeRequest(uri, protocols, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.empty());
    }

    public WsRequest handshakeRequest(Uri uri, HttpHeader ... headers) {
        return this.handshakeRequest(uri, (FingerTrieSeq<String>)FingerTrieSeq.empty(), (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public WsRequest handshakeRequest(Uri uri) {
        return this.handshakeRequest(uri, (FingerTrieSeq<String>)FingerTrieSeq.empty(), (FingerTrieSeq<HttpHeader>)FingerTrieSeq.empty());
    }

    public Value toValue() {
        return WsEngineSettings.engineForm().mold((Object)this).toValue();
    }

    protected WsEngineSettings copy(int maxFrameSize, int maxMessageSize, int serverCompressionLevel, int clientCompressionLevel, boolean serverNoContextTakeover, boolean clientNoContextTakeover, int serverMaxWindowBits, int clientMaxWindowBits) {
        return new WsEngineSettings(maxFrameSize, maxMessageSize, serverCompressionLevel, clientCompressionLevel, serverNoContextTakeover, clientNoContextTakeover, serverMaxWindowBits, clientMaxWindowBits);
    }

    public boolean canEqual(Object other) {
        return other instanceof WsEngineSettings;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof WsEngineSettings) {
            WsEngineSettings that = (WsEngineSettings)other;
            return that.canEqual(this) && this.maxFrameSize == that.maxFrameSize && this.maxMessageSize == that.maxMessageSize && this.serverCompressionLevel == that.serverCompressionLevel && this.clientCompressionLevel == that.clientCompressionLevel && this.serverNoContextTakeover == that.serverNoContextTakeover && this.clientNoContextTakeover == that.clientNoContextTakeover && this.serverMaxWindowBits == that.serverMaxWindowBits && this.clientMaxWindowBits == that.clientMaxWindowBits;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(WsEngineSettings.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.maxFrameSize), (int)this.maxMessageSize), (int)this.serverCompressionLevel), (int)this.clientCompressionLevel), (int)Murmur3.hash((boolean)this.serverNoContextTakeover)), (int)Murmur3.hash((boolean)this.clientNoContextTakeover)), (int)this.serverMaxWindowBits), (int)this.clientMaxWindowBits));
    }

    public void debug(Output<?> output) {
        output = output.write("WsEngineSettings").write(46).write("standard").write(40).write(41).write(46).write("maxFrameSize").write(40).debug((Object)this.maxFrameSize).write(41).write(46).write("maxMessageSize").write(40).debug((Object)this.maxMessageSize).write(41).write(46).write("serverCompressionLevel").write(40).debug((Object)this.serverCompressionLevel).write(41).write(46).write("clientCompressionLevel").write(40).debug((Object)this.clientCompressionLevel).write(41).write(46).write("serverNoContextTakeover").write(40).debug((Object)this.serverNoContextTakeover).write(41).write(46).write("clientNoContextTakeover").write(40).debug((Object)this.clientNoContextTakeover).write(41).write(46).write("serverMaxWindowBits").write(40).debug((Object)this.serverMaxWindowBits).write(41).write(46).write("clientMaxWindowBits").write(40).debug((Object)this.clientMaxWindowBits).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static WsEngineSettings standard() {
        if (standard == null) {
            int clientMaxWindowBits;
            int serverMaxWindowBits;
            int clientCompressionLevel;
            int serverCompressionLevel;
            int maxMessageSize;
            int maxFrameSize;
            try {
                maxFrameSize = Integer.parseInt(System.getProperty("swim.ws.max.frame.size"));
            }
            catch (NumberFormatException error) {
                maxFrameSize = 0x1000000;
            }
            try {
                maxMessageSize = Integer.parseInt(System.getProperty("swim.ws.max.message.size"));
            }
            catch (NumberFormatException error) {
                maxMessageSize = 0x1000000;
            }
            try {
                serverCompressionLevel = Integer.parseInt(System.getProperty("swim.ws.server.compression.level"));
            }
            catch (NumberFormatException error) {
                serverCompressionLevel = 0;
            }
            try {
                clientCompressionLevel = Integer.parseInt(System.getProperty("swim.ws.client.compression.level"));
            }
            catch (NumberFormatException error) {
                clientCompressionLevel = 0;
            }
            boolean serverNoContextTakeover = Boolean.parseBoolean(System.getProperty("swim.ws.server.no.context.takeover"));
            boolean clientNoContextTakeover = Boolean.parseBoolean(System.getProperty("swim.ws.client.no.context.takeover"));
            try {
                serverMaxWindowBits = Integer.parseInt(System.getProperty("swim.ws.server.max.window.bits"));
            }
            catch (NumberFormatException error) {
                serverMaxWindowBits = 15;
            }
            try {
                clientMaxWindowBits = Integer.parseInt(System.getProperty("swim.ws.client.max.window.bits"));
            }
            catch (NumberFormatException error) {
                clientMaxWindowBits = 15;
            }
            standard = new WsEngineSettings(maxFrameSize, maxMessageSize, serverCompressionLevel, clientCompressionLevel, serverNoContextTakeover, clientNoContextTakeover, serverMaxWindowBits, clientMaxWindowBits);
        }
        return standard;
    }

    public static WsEngineSettings noCompression() {
        return WsEngineSettings.standard().compressionLevel(0, 0);
    }

    public static WsEngineSettings defaultCompression() {
        return WsEngineSettings.standard().compressionLevel(-1, -1);
    }

    public static WsEngineSettings fastestCompression() {
        return WsEngineSettings.standard().compressionLevel(1, 1);
    }

    public static WsEngineSettings bestCompression() {
        return WsEngineSettings.standard().compressionLevel(9, 9);
    }

    @Kind
    public static Form<WsEngineSettings> engineForm() {
        if (engineForm == null) {
            engineForm = new WsEngineSettingsForm();
        }
        return engineForm;
    }
}

