/*
 * Decompiled with CFR 0.152.
 */
package swim.ws;

import swim.codec.Debug;
import swim.codec.Output;

public enum WsOpcode implements Debug
{
    INVALID(-1),
    CONTINUATION(0),
    TEXT(1),
    BINARY(2),
    RESERVED_3(3),
    RESERVED_4(4),
    RESERVED_5(5),
    RESERVED_6(6),
    RESERVED_7(7),
    CLOSE(8),
    PING(9),
    PONG(10),
    RESERVED_B(11),
    RESERVED_C(12),
    RESERVED_D(13),
    RESERVED_E(14),
    RESERVED_F(15);

    public final int code;

    private WsOpcode(int code) {
        this.code = code;
    }

    public boolean isValid() {
        return this.code >= 0;
    }

    public boolean isData() {
        return this.code >= 1 && this.code <= 2;
    }

    public boolean isControl() {
        return this.code >= 8;
    }

    public boolean isReserved() {
        return this.code >= 3 && this.code <= 7 || this.code >= 11 && this.code <= 15;
    }

    public boolean isContinuation() {
        return this.code == 0;
    }

    public boolean isText() {
        return this.code == 1;
    }

    public boolean isBinary() {
        return this.code == 2;
    }

    public boolean isClose() {
        return this.code == 8;
    }

    public boolean isPing() {
        return this.code == 9;
    }

    public boolean isPong() {
        return this.code == 10;
    }

    public void debug(Output<?> output) {
        output = output.write("WsOpcode").write(46).write(this.name());
    }

    public static WsOpcode from(int code) {
        switch (code) {
            case 0: {
                return CONTINUATION;
            }
            case 1: {
                return TEXT;
            }
            case 2: {
                return BINARY;
            }
            case 3: {
                return RESERVED_3;
            }
            case 4: {
                return RESERVED_4;
            }
            case 5: {
                return RESERVED_5;
            }
            case 6: {
                return RESERVED_6;
            }
            case 7: {
                return RESERVED_7;
            }
            case 8: {
                return CLOSE;
            }
            case 9: {
                return PING;
            }
            case 10: {
                return PONG;
            }
            case 11: {
                return RESERVED_B;
            }
            case 12: {
                return RESERVED_C;
            }
            case 13: {
                return RESERVED_D;
            }
            case 14: {
                return RESERVED_E;
            }
            case 15: {
                return RESERVED_F;
            }
        }
        return INVALID;
    }
}

