package ai.systema.client

import ai.systema.client.internal.SmartSearchImpl
import ai.systema.connection.RequestOptions
import ai.systema.connection.internal.Connector
import ai.systema.endpoint.EndpointSmartSearch
import ai.systema.model.request.SmartSearchRequest
import ai.systema.model.response.SmartSearchResponse

public interface SmartSearch {
    public suspend fun smartSearch(
        payload: SmartSearchRequest? = SmartSearchRequest(),
        requestOptions: RequestOptions? = null
    ): SmartSearchResponse
}

internal fun SmartSearch(
    connector: Connector
): SmartSearch = SmartSearchImpl(
    connector,
    EndpointSmartSearch(connector)
)
