package ai.systema.client.internal

import ai.systema.client.Recommender
import ai.systema.connection.RequestOptions
import ai.systema.connection.internal.Connector
import ai.systema.endpoint.EndpointRecommendation
import ai.systema.model.request.RecommendationRequest
import ai.systema.model.response.RecommendationResponse

internal class RecommenderImpl(
    private val connector: Connector,
    private val endpoint: EndpointRecommendation
) : Recommender {

    override suspend fun getRelated(
        payload: RecommendationRequest?,
        requestOptions: RequestOptions?
    ): RecommendationResponse {
        return endpoint.getRelated(connector.injectSystemaSettings(payload))
    }

    override suspend fun getComplementary(
        payload: RecommendationRequest?,
        requestOptions: RequestOptions?
    ): RecommendationResponse {
        return endpoint.getComplementary(connector.injectSystemaSettings(payload))
    }

    override suspend fun getSimilar(
        payload: RecommendationRequest?,
        requestOptions: RequestOptions?
    ): RecommendationResponse {
        return endpoint.getSimilar(connector.injectSystemaSettings(payload))
    }

    override suspend fun getCategoryTrending(
        payload: RecommendationRequest?,
        requestOptions: RequestOptions?
    ): RecommendationResponse {
        return endpoint.getCategoryTrending(connector.injectSystemaSettings(payload))
    }

    override suspend fun getCategoryPopular(
        payload: RecommendationRequest?,
        requestOptions: RequestOptions?
    ): RecommendationResponse {
        return endpoint.getCategoryPopular(connector.injectSystemaSettings(payload))
    }

    override suspend fun getTrending(
        payload: RecommendationRequest?,
        requestOptions: RequestOptions?
    ): RecommendationResponse {
        return endpoint.getTrending(connector.injectSystemaSettings(payload))
    }

    override suspend fun getPopular(
        payload: RecommendationRequest?,
        requestOptions: RequestOptions?
    ): RecommendationResponse {
        return endpoint.getPopular(connector.injectSystemaSettings(payload))
    }
}