package ai.systema.client.internal

import ai.systema.client.SmartSearch
import ai.systema.connection.RequestOptions
import ai.systema.connection.internal.Connector
import ai.systema.endpoint.EndpointSmartSearch
import ai.systema.model.request.SmartSearchRequest
import ai.systema.model.response.SmartSearchResponse

internal class SmartSearchImpl(
    private val connector: Connector,
    private val endpoint: EndpointSmartSearch
) : SmartSearch {

    override suspend fun smartSearch(
        payload: SmartSearchRequest?,
        requestOptions: RequestOptions?
    ): SmartSearchResponse {
        return endpoint.smartSearch(connector.injectSystemaSettings(payload))
    }
}