package ai.systema.configuration

import ai.systema.configuration.internal.ConfigurationImpl
import ai.systema.configuration.internal.DEFAULT_READ_TIMEOUT
import ai.systema.configuration.internal.DEFAULT_WRITE_TIMEOUT
import ai.systema.connection.RequestOptions
import ai.systema.connection.internal.hosts
import ai.systema.enums.CallType
import ai.systema.enums.EndpointType
import ai.systema.helper.logging.SystemaLogLevel
import io.ktor.client.*
import io.ktor.client.engine.*

public interface Configuration {
    public val credentials: Credentials


    public val writeTimeout: Long

    public val readTimeout: Long

    public val logLevel: SystemaLogLevel

    public val httpClientConfig: ((HttpClientConfig<*>) -> Unit)?

    public val engine: HttpClientEngine?

    public val hosts: Map<EndpointType, List<RetryableHost>>

    public val httpClient: HttpClient

    public val defaultHeaders: Map<String, String>?

    public val compression: Compression

    public val kvStore: SystemaKVStore

    public fun RequestOptions?.getTimeout(callType: CallType): Long {
        return when (callType) {
            CallType.Read -> this?.readTimeout ?: readTimeout
            CallType.Write -> this?.writeTimeout ?: writeTimeout
        }
    }
}

public fun Configuration(
    credentials: Credentials,
    writeTimeout: Long = DEFAULT_WRITE_TIMEOUT,
    readTimeout: Long = DEFAULT_READ_TIMEOUT,
    logLevel: SystemaLogLevel = SystemaLogLevel.INFO,
    hosts: Map<EndpointType, List<RetryableHost>> = credentials.hosts,
    defaultHeaders: Map<String, String>? = null,
    engine: HttpClientEngine? = null,
    httpClientConfig: (HttpClientConfig<*>.() -> Unit)? = null,
    compression: Compression = Compression.None,
    kvStore: SystemaKVStore,
): Configuration = ConfigurationImpl(
    credentials,
    writeTimeout,
    readTimeout,
    logLevel = logLevel,
    hosts,
    defaultHeaders,
    engine,
    httpClientConfig,
    compression,
    kvStore,
)
