package ai.systema.helper.logging

import kotlinx.datetime.Clock

internal object SystemaLoggerFactory {
    fun logger(logSrc: String = "SystemaLogger", level: SystemaLogLevel = SystemaLogLevel.DEBUG): SystemaSimpleLogger {
        return SystemaSimpleLogger(logSrc, level)
    }
}

internal class SystemaSimpleLogger(
    private val logSrc: String,
    private val logLevel: SystemaLogLevel,
) {
    private fun log(message: String, level: SystemaLogLevel) {
        if (level != SystemaLogLevel.NONE) {
            val now = Clock.System.now()
            println("$now $level $logSrc - $message")
        }
    }

    fun debug(message: String) {
        if (logLevel >= SystemaLogLevel.DEBUG) {
            log(message, SystemaLogLevel.DEBUG)
        }
    }

    fun info(message: String) {
        if (logLevel >= SystemaLogLevel.INFO) {
            log(message, SystemaLogLevel.INFO)
        }
    }

    fun warn(message: String) {
        if (logLevel >= SystemaLogLevel.WARN) {
            log(message, SystemaLogLevel.WARN)
        }
    }

    fun error(message: String) {
        if (logLevel >= SystemaLogLevel.ERROR) {
            log(message, SystemaLogLevel.ERROR)
        }
    }

}