package ai.systema.model.request

import ai.systema.serialize.Keys
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
public data class Filter(
    @SerialName(Keys.Id) val id: List<String>? = listOf(),
    @SerialName(Keys.Text) val text: String? = "",
    @SerialName(Keys.Brand) val brand: String? = "",
    @SerialName(Keys.Category) val category: List<String>? = listOf(),
    @SerialName(Keys.Price) val price: Map<String, List<Double>>? = null,
    @SerialName(Keys.SalePrice) val salePrice: Map<String, List<Double>>? = mapOf(),
    @SerialName(Keys.OnSaleOnly) val onSaleOnly: Boolean? = false,
    @SerialName(Keys.InStockOnly) val inStockOnly: Boolean? = false,
    @SerialName(Keys.Tags) val tags: List<String>? = listOf(),
    @SerialName(Keys.Meta) val meta: Map<String, String>? = null, // this is for future customized extension
)
