package ai.systema.model.request

import ai.systema.constants.LanguagesISO6392
import ai.systema.serialize.Keys
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonElement

@Serializable
public data class RecommendationRequest(
    @SerialName(Keys.Environment) var environment: String? = null,
    @SerialName(Keys.UserId) var user: RequestUser? = null,
    @SerialName(Keys.Id) val id: String? = null,
    @SerialName(Keys.Category) val category: List<String>? = null,
    @SerialName(Keys.Size) val size: Int? = 10,
    @SerialName(Keys.Start) val start: Int? = 0,
    @SerialName(Keys.Filter) val filter: Filter? = null,
    @SerialName(Keys.Exclusion) val exclusion: Filter? = null,
    @SerialName(Keys.PaginationTimestamp) val paginationTimestamp: Long? = null,
    @SerialName(Keys.Language) val language: String? = LanguagesISO6392.English,
    @SerialName(Keys.Display) val display: List<String>? = null,
    @SerialName(Keys.DisplayVariants) val displayVariants: List<String>? = null,
    @SerialName(Keys.Meta) val meta: Map<String, JsonElement>? = null, // this is for future customized extension
)
