package ai.systema.android.listener

import ai.systema.client.SystemaAI
import android.view.View
import io.ktor.client.statement.HttpResponse
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.Dispatchers

public class SystemaOnLayoutChangeListener(
    systema: SystemaAI,
    tagMapping: Map<String, Int>,
    dispatcher: CoroutineDispatcher = Dispatchers.IO,
    callback: (Result<HttpResponse>) -> Unit,
) : View.OnLayoutChangeListener, SystemaCompositeListener<View.OnLayoutChangeListener>() {

    init {
        addListener(SystemaEventListener(systema, tagMapping, dispatcher, callback))
    }

    override fun onLayoutChange(
        v: View?,
        left: Int,
        top: Int,
        right: Int,
        bottom: Int,
        oldLeft: Int,
        oldTop: Int,
        oldRight: Int,
        oldBottom: Int
    ) {
        v ?: return
        for (listener in listenerList) {
            listener.onLayoutChange(
                v,
                left,
                top,
                right,
                bottom,
                oldLeft,
                oldTop,
                oldRight,
                oldBottom
            )
        }
    }
}
