package ai.systema.android.listener

import ai.systema.client.SystemaAI
import android.view.View


public class SystemaOnAttachStateChangeListener(
    private val systema: SystemaAI,
    private val tagMapping: Map<String, Int>,
) : View.OnAttachStateChangeListener {

    private val listeners: MutableList<View.OnAttachStateChangeListener> = mutableListOf(
        SystemaEventListener(systema, tagMapping)
    )

    public fun addOnAttachStateChangeListener(listener: View.OnAttachStateChangeListener?): SystemaOnAttachStateChangeListener {
        if (listener != null) {
            listeners.add(listener)
        }

        return this
    }

    override fun onViewAttachedToWindow(v: View?) {
        for (listener in listeners) {
            listener.onViewAttachedToWindow(v)
        }
    }

    override fun onViewDetachedFromWindow(v: View?) {
        for (listener in listeners) {
            listener.onViewDetachedFromWindow(v)
        }
    }
}

