package ai.systema.android.listener

import ai.systema.client.SystemaAI
import android.view.View


public class SystemaOnLayoutChangeListener(
    private val systema: SystemaAI,
    private val tagMapping: Map<String, Int>,
) : View.OnLayoutChangeListener {

    private val layoutChangeListeners: MutableList<View.OnLayoutChangeListener> = mutableListOf(
        SystemaEventListener(systema, tagMapping)
    )

    public fun addOnLayoutChangeListener(listener: View.OnLayoutChangeListener?): SystemaOnLayoutChangeListener {
        if (listener != null) {
            layoutChangeListeners.add(listener)
        }

        return this
    }

    override fun onLayoutChange(
        v: View?,
        left: Int,
        top: Int,
        right: Int,
        bottom: Int,
        oldLeft: Int,
        oldTop: Int,
        oldRight: Int,
        oldBottom: Int
    ) {
        for (listener in layoutChangeListeners) {
            listener.onLayoutChange(
                v,
                left,
                top,
                right,
                bottom,
                oldLeft,
                oldTop,
                oldRight,
                oldBottom
            )
        }
    }
}

