package ai.systema.client

import ai.systema.client.internal.RecommenderImpl
import ai.systema.connection.RequestOptions
import ai.systema.connection.internal.Connector
import ai.systema.endpoint.EndpointRecommendation
import ai.systema.model.request.RecommendationRequest
import ai.systema.model.response.RecommendationResponse

public interface Recommender {

    public suspend fun getRelated(
        payload: RecommendationRequest? = RecommendationRequest(),
        requestOptions: RequestOptions? = null,
    ): RecommendationResponse

    public suspend fun getComplementary(
        payload: RecommendationRequest? = RecommendationRequest(),
        requestOptions: RequestOptions? = null,
    ): RecommendationResponse

    public suspend fun getSimilar(
        payload: RecommendationRequest? = RecommendationRequest(),
        requestOptions: RequestOptions? = null,
    ): RecommendationResponse

    public suspend fun getCategoryTrending(
        payload: RecommendationRequest? = RecommendationRequest(),
        requestOptions: RequestOptions? = null,
    ): RecommendationResponse

    public suspend fun getCategoryPopular(
        payload: RecommendationRequest? = RecommendationRequest(),
        requestOptions: RequestOptions? = null,
    ): RecommendationResponse

    public suspend fun getTrending(
        payload: RecommendationRequest? = RecommendationRequest(),
        requestOptions: RequestOptions? = null,
    ): RecommendationResponse

    public suspend fun getPopular(
        payload: RecommendationRequest? = RecommendationRequest(),
        requestOptions: RequestOptions? = null,
    ): RecommendationResponse
}

internal fun Recommender(
    connector: Connector
): Recommender = RecommenderImpl(
    connector,
    EndpointRecommendation(connector)
)
