package ai.systema.client

import ai.systema.client.internal.SmartSuggestImpl
import ai.systema.connection.RequestOptions
import ai.systema.connection.internal.Connector
import ai.systema.endpoint.EndpointSmartSuggest
import ai.systema.model.request.SmartSuggestRequest
import ai.systema.model.response.SmartSuggestResponse

public interface SmartSuggest {
    public suspend fun smartSuggest(
        payload: SmartSuggestRequest? = SmartSuggestRequest(query = ""),
        requestOptions: RequestOptions? = null
    ): SmartSuggestResponse
}

internal fun SmartSuggest(
    connector: Connector
): SmartSuggest = SmartSuggestImpl(
    connector,
    EndpointSmartSuggest(connector)
)
