package ai.systema.client.internal

import ai.systema.client.SmartSuggest
import ai.systema.connection.RequestOptions
import ai.systema.connection.internal.Connector
import ai.systema.endpoint.EndpointSmartSuggest
import ai.systema.model.request.SmartSuggestRequest
import ai.systema.model.response.SmartSuggestResponse

internal class SmartSuggestImpl(
    private val connector: Connector,
    private val endpoint: EndpointSmartSuggest
) : SmartSuggest {

    override suspend fun smartSuggest(
        payload: SmartSuggestRequest?,
        requestOptions: RequestOptions?
    ): SmartSuggestResponse {
        return endpoint.smartSuggest(connector.injectSystemaSettings(payload))
    }
}