package ai.systema.configuration

import ai.systema.helper.internal.UUID
import ai.systema.helper.logging.SystemaLoggerFactory
import ai.systema.model.ClientUser
import ai.systema.serialize.Keys

internal object Impersonate {
    private val logger = SystemaLoggerFactory.logger(Impersonate::class.toString())
    internal suspend fun clientUser(kvStore: SystemaKVStore): ClientUser {
        val clientUser = ClientUser(
            fingerprint = genFingerprint(kvStore),
        )

        clientUser.refreshSession(kvStore)

        return clientUser
    }

    private suspend fun genFingerprint(kvStore: SystemaKVStore): String {
        var fingerprint = kvStore.read(Keys.Fingerprint)
        if (fingerprint != null) {
            return fingerprint
        }

        fingerprint = UUID.randomUUID()
        kvStore.write(Keys.Fingerprint, fingerprint)
        return fingerprint
    }
}